/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.pis.Xs2aCurrencyConversionInfo;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.BaseAuthorisationProcessorService;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

abstract class PaymentBaseAuthorisationProcessorService
extends BaseAuthorisationProcessorService {
    private static final String EMBEDDED_SELECTING_SCA_METHOD_FAILED_MSG = "Proceed embedded approach when performs authorisation depending on selected SCA method has failed.";
    private List<PisScaAuthorisationService> services;
    private Xs2aAuthorisationService xs2aAuthorisationService;
    private Xs2aPisCommonPaymentService xs2aPisCommonPaymentService;
    private Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper;
    private SpiContextDataProvider spiContextDataProvider;
    private SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private SpiErrorMapper spiErrorMapper;
    private PisAspspDataService pisAspspDataService;
    private Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;

    protected PaymentBaseAuthorisationProcessorService(List<PisScaAuthorisationService> services, Xs2aAuthorisationService xs2aAuthorisationService, Xs2aPisCommonPaymentService xs2aPisCommonPaymentService, Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, PisAspspDataService pisAspspDataService, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper) {
        this.services = services;
        this.xs2aAuthorisationService = xs2aAuthorisationService;
        this.xs2aPisCommonPaymentService = xs2aPisCommonPaymentService;
        this.xs2aToSpiPaymentMapper = xs2aToSpiPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.pisAspspDataService = pisAspspDataService;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToSpiPsuDataMapper = xs2aToSpiPsuDataMapper;
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuIdentified(AuthorisationProcessorRequest authorisationProcessorRequest) {
        return this.doScaReceived(authorisationProcessorRequest);
    }

    @Override
    public AuthorisationProcessorResponse doScaFinalised(AuthorisationProcessorRequest authorisationProcessorRequest) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = this.getSpiCurrencyConversionInfoSpiResponse(authorisationProcessorRequest, request);
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.FINALISED, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData(), xs2aCurrencyConversionInfo);
    }

    private Xs2aCurrencyConversionInfo getSpiCurrencyConversionInfoSpiResponse(AuthorisationProcessorRequest authorisationProcessorRequest, Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        String authorisationId = request.getAuthorisationId();
        SpiPayment payment = this.getSpiPayment(request.getPaymentId());
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getPaymentId());
        return this.getCurrencyConversionInfo(contextData, payment, authorisationId, aspspConsentDataProvider);
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuAuthenticated(AuthorisationProcessorRequest authorisationProcessorRequest) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        SpiPayment payment = this.getSpiPayment(request.getPaymentId());
        if (this.isDecoupledApproach(request.getAuthorisationId(), request.getAuthenticationMethodId())) {
            this.xs2aAuthorisationService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.proceedDecoupledApproach(request, payment, request.getAuthenticationMethodId());
        }
        return this.proceedEmbeddedApproach(authorisationProcessorRequest, payment);
    }

    @Override
    public AuthorisationProcessorResponse doScaMethodSelected(AuthorisationProcessorRequest authorisationProcessorRequest) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        String authorisationId = request.getAuthorisationId();
        String paymentId = request.getPaymentId();
        String internalId = this.pisAspspDataService.getInternalPaymentIdByEncryptedString(paymentId);
        SpiScaConfirmation spiScaConfirmation = this.xs2aPisCommonPaymentMapper.buildSpiScaConfirmation(request, authorisation.getParentId(), internalId, psuData);
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId);
        SpiPayment payment = this.getSpiPayment(request.getPaymentId());
        SpiResponse<SpiPaymentExecutionResponse> spiResponse = this.verifyScaAuthorisationAndExecutePayment(authorisation, payment, spiScaConfirmation, contextData, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Verify SCA authorisation and execute payment has failed.");
            SpiPaymentExecutionResponse spiPaymentResponse = (SpiPaymentExecutionResponse)spiResponse.getPayload();
            if (spiPaymentResponse != null && spiPaymentResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.ATTEMPT_FAILURE) {
                return new Xs2aUpdatePisCommonPaymentPsuDataResponse(authorisationProcessorRequest.getScaStatus(), errorHolder, paymentId, authorisationId, psuData);
            }
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        this.updatePaymentDataByPaymentResponse(paymentId, spiResponse);
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = this.getCurrencyConversionInfo(contextData, payment, request.getAuthorisationId(), aspspConsentDataProvider);
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.FINALISED, paymentId, authorisationId, psuData, xs2aCurrencyConversionInfo);
    }

    abstract void updatePaymentDataByPaymentResponse(String var1, SpiResponse<SpiPaymentExecutionResponse> var2);

    abstract SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(SpiPayment var1, String var2, SpiContextData var3, SpiAspspConsentDataProvider var4);

    abstract SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePayment(Authorisation var1, SpiPayment var2, SpiScaConfirmation var3, SpiContextData var4, SpiAspspConsentDataProvider var5);

    abstract SpiResponse<SpiPsuAuthorisationResponse> authorisePsu(Xs2aUpdatePisCommonPaymentPsuDataRequest var1, SpiPayment var2, SpiAspspConsentDataProvider var3, SpiPsuData var4, SpiContextData var5, String var6);

    abstract SpiResponse<SpiAvailableScaMethodsResponse> requestAvailableScaMethods(SpiPayment var1, SpiAspspConsentDataProvider var2, SpiContextData var3);

    abstract Xs2aUpdatePisCommonPaymentPsuDataResponse executePaymentWithoutSca(AuthorisationProcessorRequest var1, PsuIdData var2, PaymentType var3, SpiPayment var4, SpiContextData var5, ScaStatus var6, Xs2aCurrencyConversionInfo var7);

    abstract Xs2aUpdatePisCommonPaymentPsuDataResponse proceedDecoupledApproach(Xs2aUpdatePisCommonPaymentPsuDataRequest var1, SpiPayment var2, String var3);

    abstract boolean needProcessExemptedSca(PaymentType var1, boolean var2);

    abstract Xs2aCurrencyConversionInfo getCurrencyConversionInfo(SpiContextData var1, SpiPayment var2, String var3, SpiAspspConsentDataProvider var4);

    PisScaAuthorisationService getService(ScaApproach scaApproach) {
        return this.services.stream().filter(s -> s.getScaApproachServiceType() == scaApproach).findFirst().orElseThrow(() -> new IllegalArgumentException("Pis cancellation authorisation service was not found for approach " + scaApproach));
    }

    Xs2aUpdatePisCommonPaymentPsuDataResponse applyAuthorisation(AuthorisationProcessorRequest authorisationProcessorRequest) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        String authorisationId = request.getAuthorisationId();
        String paymentId = request.getPaymentId();
        SpiPayment payment = this.getSpiPayment(paymentId);
        request.setPsuData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId);
        SpiPsuData spiPsuData = this.xs2aToSpiPsuDataMapper.mapToSpiPsuData(psuData);
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse<SpiPsuAuthorisationResponse> authPsuResponse = this.authorisePsu(request, payment, aspspConsentDataProvider, spiPsuData, contextData, authorisationId);
        if (authPsuResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(authPsuResponse, ServiceType.PIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Authorise PSU when apply authorisation has failed.");
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        SpiPsuAuthorisationResponse psuAuthorisationResponse = (SpiPsuAuthorisationResponse)authPsuResponse.getPayload();
        if (psuAuthorisationResponse.getSpiAuthorisationStatus() == SpiAuthorisationStatus.FAILURE) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_401).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID)}).build();
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "PSU authorisation failed due to incorrect credentials.");
            this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = this.getCurrencyConversionInfo(contextData, payment, request.getAuthorisationId(), aspspConsentDataProvider);
        PaymentType paymentType = request.getPaymentService();
        if (this.needProcessExemptedSca(paymentType, psuAuthorisationResponse.isScaExempted())) {
            this.writeInfoLog(authorisationProcessorRequest, psuData, "SCA was exempted for the payment after AuthorisationSpi#authorisePsu.");
            return this.executePaymentWithoutSca(authorisationProcessorRequest, psuData, paymentType, payment, contextData, ScaStatus.EXEMPTED, xs2aCurrencyConversionInfo);
        }
        SpiResponse<SpiAvailableScaMethodsResponse> availableScaMethodsResponse = this.requestAvailableScaMethods(payment, aspspConsentDataProvider, contextData);
        if (availableScaMethodsResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(availableScaMethodsResponse, ServiceType.PIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Request available SCA methods has failed.");
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        SpiAvailableScaMethodsResponse availableScaMethods = (SpiAvailableScaMethodsResponse)availableScaMethodsResponse.getPayload();
        if (this.needProcessExemptedSca(paymentType, availableScaMethods.isScaExempted())) {
            this.writeInfoLog(authorisationProcessorRequest, psuData, "SCA was exempted for the payment after AuthorisationSpi#requestAvailableScaMethods.");
            return this.executePaymentWithoutSca(authorisationProcessorRequest, psuData, paymentType, payment, contextData, ScaStatus.EXEMPTED, xs2aCurrencyConversionInfo);
        }
        List spiScaMethods = availableScaMethods.getAvailableScaMethods();
        return this.processScaMethods(authorisationProcessorRequest, psuData, paymentType, payment, aspspConsentDataProvider, contextData, spiScaMethods, xs2aCurrencyConversionInfo);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse processScaMethods(@NotNull AuthorisationProcessorRequest authorisationProcessorRequest, PsuIdData psuData, PaymentType paymentType, SpiPayment payment, SpiAspspConsentDataProvider aspspConsentDataProvider, SpiContextData contextData, List<AuthenticationObject> spiScaMethods, Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        if (CollectionUtils.isEmpty(spiScaMethods)) {
            this.writeInfoLog(authorisationProcessorRequest, psuData, "Available SCA methods is empty.");
            return this.executePaymentWithoutSca(authorisationProcessorRequest, psuData, paymentType, payment, contextData, ScaStatus.FINALISED, xs2aCurrencyConversionInfo);
        }
        if (this.isSingleScaMethod(spiScaMethods)) {
            return this.buildUpdateResponseWhenScaMethodIsSingle(authorisationProcessorRequest, psuData, payment, aspspConsentDataProvider, contextData, spiScaMethods, xs2aCurrencyConversionInfo);
        }
        if (this.isMultipleScaMethods(spiScaMethods)) {
            return this.buildUpdateResponseWhenScaMethodsAreMultiple(request, psuData, spiScaMethods);
        }
        this.writeInfoLog(authorisationProcessorRequest, psuData, "Apply authorisation when update payment PSU data set SCA status failed.");
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.FAILED, request.getPaymentId(), request.getAuthorisationId(), psuData, xs2aCurrencyConversionInfo);
    }

    Xs2aUpdatePisCommonPaymentPsuDataResponse applyIdentification(AuthorisationProcessorRequest authorisationProcessorRequest) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String paymentId = request.getPaymentId();
        String authorisationId = request.getAuthorisationId();
        PsuIdData psuData = request.getPsuData();
        if (!this.isPsuExist(psuData)) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NO_PSU)}).build();
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Apply identification when update payment PSU data has failed. No PSU data available in request.");
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getPaymentId());
        SpiPayment payment = this.getSpiPayment(request.getPaymentId());
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = this.getCurrencyConversionInfo(contextData, payment, authorisationId, aspspConsentDataProvider);
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.PSUIDENTIFIED, paymentId, authorisationId, psuData, xs2aCurrencyConversionInfo);
    }

    Xs2aUpdatePisCommonPaymentPsuDataResponse buildUpdateResponseWhenScaMethodsAreMultiple(Xs2aUpdatePisCommonPaymentPsuDataRequest request, PsuIdData psuData, List<AuthenticationObject> spiScaMethods) {
        this.xs2aAuthorisationService.saveAuthenticationMethods(request.getAuthorisationId(), spiScaMethods);
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.PSUAUTHENTICATED, request.getPaymentId(), request.getAuthorisationId(), psuData);
        response.setAvailableScaMethods(spiScaMethods);
        return response;
    }

    Xs2aUpdatePisCommonPaymentPsuDataResponse buildUpdateResponseWhenScaMethodIsSingle(AuthorisationProcessorRequest authorisationProcessorRequest, PsuIdData psuData, SpiPayment payment, SpiAspspConsentDataProvider aspspConsentDataProvider, SpiContextData contextData, List<AuthenticationObject> scaMethods, Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        this.xs2aAuthorisationService.saveAuthenticationMethods(request.getAuthorisationId(), scaMethods);
        AuthenticationObject chosenMethod = scaMethods.get(0);
        if (chosenMethod.isDecoupled()) {
            this.xs2aAuthorisationService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.proceedDecoupledApproach(request, payment, chosenMethod.getAuthenticationMethodId());
        }
        return this.proceedSingleScaEmbeddedApproach(authorisationProcessorRequest, payment, chosenMethod, contextData, aspspConsentDataProvider, psuData, xs2aCurrencyConversionInfo);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse proceedSingleScaEmbeddedApproach(AuthorisationProcessorRequest authorisationProcessorRequest, SpiPayment payment, AuthenticationObject chosenMethod, SpiContextData contextData, SpiAspspConsentDataProvider spiAspspConsentDataProvider, PsuIdData psuData, Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String authorisationId = request.getAuthorisationId();
        SpiResponse<SpiAuthorizationCodeResult> authCodeResponse = this.requestAuthorisationCode(payment, chosenMethod.getAuthenticationMethodId(), contextData, spiAspspConsentDataProvider);
        if (authCodeResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(authCodeResponse, ServiceType.PIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Proceed single SCA embedded approach when performs authorisation has failed.");
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, request.getPaymentId(), authorisationId, psuData);
        }
        SpiAuthorizationCodeResult authorizationCodeResult = (SpiAuthorizationCodeResult)authCodeResponse.getPayload();
        if (this.needProcessExemptedSca(payment.getPaymentType(), authorizationCodeResult.isScaExempted())) {
            this.writeInfoLog(authorisationProcessorRequest, psuData, "SCA was exempted for the payment after AuthorisationSpi#requestAuthorisationCode.");
            return this.executePaymentWithoutSca(authorisationProcessorRequest, psuData, payment.getPaymentType(), payment, contextData, ScaStatus.EXEMPTED, xs2aCurrencyConversionInfo);
        }
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = new Xs2aUpdatePisCommonPaymentPsuDataResponse(authorizationCodeResult.getScaStatus(), payment.getPaymentId(), authorisationId, psuData, xs2aCurrencyConversionInfo);
        response.setChosenScaMethod(authorizationCodeResult.getSelectedScaMethod());
        response.setChallengeData(this.mapToChallengeData(authorizationCodeResult));
        return response;
    }

    private boolean isDecoupledApproach(String authorisationId, String authenticationMethodId) {
        return this.xs2aAuthorisationService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse proceedEmbeddedApproach(AuthorisationProcessorRequest authorisationProcessorRequest, SpiPayment payment) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = (Xs2aUpdatePisCommonPaymentPsuDataRequest)authorisationProcessorRequest.getUpdateAuthorisationRequest();
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        String authenticationMethodId = request.getAuthenticationMethodId();
        String authorisationId = request.getAuthorisationId();
        String paymentId = request.getPaymentId();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(paymentId);
        SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.requestAuthorisationCode(payment, authenticationMethodId, contextData, aspspConsentDataProvider);
        if (payment == null || spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, EMBEDDED_SELECTING_SCA_METHOD_FAILED_MSG);
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.xs2aAuthorisationService.updateAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        Xs2aCurrencyConversionInfo xs2aCurrencyConversionInfo = this.getCurrencyConversionInfo(contextData, payment, request.getAuthorisationId(), aspspConsentDataProvider);
        SpiAuthorizationCodeResult authorizationCodeResult = (SpiAuthorizationCodeResult)spiResponse.getPayload();
        if (this.needProcessExemptedSca(payment.getPaymentType(), authorizationCodeResult.isScaExempted())) {
            this.writeInfoLog(authorisationProcessorRequest, psuData, "SCA was exempted for the payment after AuthorisationSpi#requestAuthorisationCode.");
            return this.executePaymentWithoutSca(authorisationProcessorRequest, psuData, payment.getPaymentType(), payment, contextData, ScaStatus.EXEMPTED, xs2aCurrencyConversionInfo);
        }
        if (authorizationCodeResult.isEmpty()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR)}).build();
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, EMBEDDED_SELECTING_SCA_METHOD_FAILED_MSG);
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
        }
        AuthenticationObject authenticationObject = authorizationCodeResult.getSelectedScaMethod();
        ChallengeData challengeData = authorizationCodeResult.getChallengeData();
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = new Xs2aUpdatePisCommonPaymentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, paymentId, authorisationId, psuData, xs2aCurrencyConversionInfo);
        response.setChosenScaMethod(authenticationObject);
        response.setChallengeData(challengeData);
        return response;
    }

    protected SpiPayment getSpiPayment(String encryptedPaymentId) {
        Optional<PisCommonPaymentResponse> commonPaymentById = this.xs2aPisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        return commonPaymentById.map(pisCommonPaymentResponse -> this.xs2aToSpiPaymentMapper.mapToSpiPayment((PisCommonPaymentResponse)pisCommonPaymentResponse)).orElse(null);
    }
}

