/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.raw;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FieldExtractor {
    private final ErrorBuildingService errorBuildingService;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public Optional<String> extractField(HttpServletRequest request, String fieldName, MessageError messageError) {
        Optional fieldOptional = Optional.empty();
        try {
            fieldOptional = this.xs2aObjectMapper.toJsonField((InputStream)request.getInputStream(), fieldName, (TypeReference)new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
        }
        return fieldOptional;
    }

    public Optional<String> extractOptionalField(HttpServletRequest request, String fieldName) {
        try {
            return this.xs2aObjectMapper.toJsonField((InputStream)request.getInputStream(), fieldName, (TypeReference)new TypeReference<String>(){});
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public List<String> extractList(HttpServletRequest request, String fieldName, MessageError messageError) {
        ArrayList<String> fieldList = new ArrayList<String>();
        try {
            fieldList.addAll(this.xs2aObjectMapper.toJsonGetValuesForField((InputStream)request.getInputStream(), fieldName));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
        }
        return fieldList;
    }

    public List<String> extractOptionalList(HttpServletRequest request, String fieldName) {
        try {
            return this.xs2aObjectMapper.toJsonGetValuesForField((InputStream)request.getInputStream(), fieldName);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public <T> Optional<T> mapBodyToInstance(HttpServletRequest request, MessageError messageError, Class<T> clazz) {
        try {
            return Optional.of(this.xs2aObjectMapper.readValue((InputStream)request.getInputStream(), clazz));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
            return Optional.empty();
        }
    }

    @ConstructorProperties(value={"errorBuildingService", "xs2aObjectMapper"})
    public FieldExtractor(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper) {
        this.errorBuildingService = errorBuildingService;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

