/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAccountConsentAuthorizationMapper;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPiisConsentMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Xs2aPiisConsentMapperImpl
extends Xs2aPiisConsentMapper {
    @Autowired
    private ConsentDataMapper consentDataMapper;
    @Autowired
    private Xs2aAccountConsentAuthorizationMapper xs2aAccountConsentAuthorizationMapper;

    @Override
    public PiisConsent mapToPiisConsent(CmsConsent cmsConsent) {
        if (cmsConsent == null) {
            return null;
        }
        PiisConsent piisConsent = new PiisConsent();
        piisConsent.setConsentTppInformation(cmsConsent.getTppInformation());
        piisConsent.setConsentData((Object)this.consentDataMapper.mapToPiisConsentData(cmsConsent.getConsentData()));
        piisConsent.setId(cmsConsent.getId());
        piisConsent.setInternalRequestId(cmsConsent.getInternalRequestId());
        piisConsent.setConsentStatus(cmsConsent.getConsentStatus());
        piisConsent.setFrequencyPerDay(cmsConsent.getFrequencyPerDay());
        piisConsent.setRecurringIndicator(cmsConsent.isRecurringIndicator());
        piisConsent.setMultilevelScaRequired(cmsConsent.isMultilevelScaRequired());
        piisConsent.setValidUntil(cmsConsent.getValidUntil());
        piisConsent.setExpireDate(cmsConsent.getExpireDate());
        piisConsent.setLastActionDate(cmsConsent.getLastActionDate());
        piisConsent.setCreationTimestamp(cmsConsent.getCreationTimestamp());
        piisConsent.setStatusChangeTimestamp(cmsConsent.getStatusChangeTimestamp());
        piisConsent.setAuthorisationTemplate(cmsConsent.getAuthorisationTemplate());
        List list = cmsConsent.getPsuIdDataList();
        if (list != null) {
            piisConsent.setPsuIdDataList(new ArrayList(list));
        }
        piisConsent.setAuthorisations(this.xs2aAccountConsentAuthorizationMapper.mapToAccountConsentAuthorisation(cmsConsent.getAuthorisations()));
        Map map = cmsConsent.getUsages();
        if (map != null) {
            piisConsent.setUsages(new HashMap(map));
        }
        piisConsent.setTppAccountAccesses(cmsConsent.getTppAccountAccesses());
        piisConsent.setAspspAccountAccesses(cmsConsent.getAspspAccountAccesses());
        piisConsent.setInstanceId(cmsConsent.getInstanceId());
        piisConsent.setConsentType(cmsConsent.getConsentType());
        return piisConsent;
    }
}

