/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.AdditionalInformationStructured;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.model.RemittanceInformationUnstructuredArray;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.StandingOrderDetails;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountModelMapperImpl
extends AccountModelMapper {
    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setCurrency(this.accountReferenceCurrencyCurrencyCode(accountReference));
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setOtherAccountIdentification(accountReference.getOtherAccountIdentification());
        return accountReference1;
    }

    @Override
    public List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> accountReferences) {
        if (accountReferences == null) {
            return null;
        }
        ArrayList<AccountReference> list = new ArrayList<AccountReference>(accountReferences.size());
        for (de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference : accountReferences) {
            list.add(this.mapToAccountReference(accountReference));
        }
        return list;
    }

    @Override
    public AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        AccountDetails accountDetails1 = new AccountDetails();
        accountDetails1.setUsage(this.xs2aUsageTypeToUsageEnum(accountDetails.getUsageType()));
        accountDetails1.setStatus(this.accountStatusToAccountStatus(accountDetails.getAccountStatus()));
        accountDetails1.setResourceId(accountDetails.getResourceId());
        accountDetails1.setIban(accountDetails.getIban());
        accountDetails1.setBban(accountDetails.getBban());
        accountDetails1.setMsisdn(accountDetails.getMsisdn());
        accountDetails1.setName(accountDetails.getName());
        accountDetails1.setDisplayName(accountDetails.getDisplayName());
        accountDetails1.setProduct(accountDetails.getProduct());
        if (accountDetails.getCashAccountType() != null) {
            accountDetails1.setCashAccountType(accountDetails.getCashAccountType().name());
        }
        accountDetails1.setBic(accountDetails.getBic());
        accountDetails1.setLinkedAccounts(accountDetails.getLinkedAccounts());
        accountDetails1.setDetails(accountDetails.getDetails());
        accountDetails1.setBalances(this.mapToBalanceList(accountDetails.getBalances()));
        accountDetails1.setOwnerName(accountDetails.getOwnerName());
        accountDetails1.setLinks(this.hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()));
        accountDetails1.setCurrency(this.mapToAccountDetailsCurrency(accountDetails.getCurrency()));
        return accountDetails1;
    }

    @Override
    public Balance mapToBalance(Xs2aBalance balance) {
        if (balance == null) {
            return null;
        }
        Balance balance1 = new Balance();
        balance1.setBalanceAmount(this.amountModelMapper.mapToAmount(balance.getBalanceAmount()));
        balance1.setCreditLimitIncluded(balance.getCreditLimitIncluded());
        balance1.setReferenceDate(balance.getReferenceDate());
        balance1.setLastCommittedTransaction(balance.getLastCommittedTransaction());
        balance1.setLastChangeDateTime(this.mapToOffsetDateTime(balance.getLastChangeDateTime()));
        balance1.setBalanceType(this.mapToBalanceType(balance.getBalanceType()));
        return balance1;
    }

    @Override
    public ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        ReadAccountBalanceResponse200 readAccountBalanceResponse200 = new ReadAccountBalanceResponse200();
        readAccountBalanceResponse200.setAccount(this.mapToAccountReference(balancesReport.getXs2aAccountReference()));
        readAccountBalanceResponse200.setBalances(this.mapToBalanceList(balancesReport.getBalances()));
        return readAccountBalanceResponse200;
    }

    @Override
    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        if (accountReport == null) {
            return null;
        }
        AccountReport accountReport1 = new AccountReport();
        accountReport1.setBooked(this.mapToTransactionList(accountReport.getBooked()));
        accountReport1.setPending(this.mapToTransactionList(accountReport.getPending()));
        accountReport1.setInformation(this.mapToTransactionList(accountReport.getInformation()));
        accountReport1.setLinks(this.hrefLinkMapper.mapToLinksMap(accountReport.getLinks()));
        return accountReport1;
    }

    @Override
    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        if (transactionsReport == null) {
            return null;
        }
        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();
        transactionsResponse200Json.setTransactions(this.mapToAccountReport(transactionsReport.getAccountReport()));
        transactionsResponse200Json.setAccount(this.mapToAccountReference(transactionsReport.getAccountReference()));
        transactionsResponse200Json.setBalances(this.mapToBalanceList(transactionsReport.getBalances()));
        transactionsResponse200Json.setLinks(this.hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()));
        return transactionsResponse200Json;
    }

    @Override
    public de.adorsys.psd2.model.Transactions mapToTransactions(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        de.adorsys.psd2.model.Transactions transactions1 = new de.adorsys.psd2.model.Transactions();
        transactions1.setBankTransactionCode(this.transactionsBankTransactionCodeCodeCode(transactions));
        transactions1.setTransactionAmount(this.amountModelMapper.mapToAmount(transactions.getAmount()));
        transactions1.setTransactionId(transactions.getTransactionId());
        transactions1.setEntryReference(transactions.getEntryReference());
        transactions1.setEndToEndId(transactions.getEndToEndId());
        transactions1.setMandateId(transactions.getMandateId());
        transactions1.setCheckId(transactions.getCheckId());
        transactions1.setCreditorId(transactions.getCreditorId());
        transactions1.setBookingDate(transactions.getBookingDate());
        transactions1.setValueDate(transactions.getValueDate());
        transactions1.setCreditorName(transactions.getCreditorName());
        transactions1.setCreditorAccount(this.mapToAccountReference(transactions.getCreditorAccount()));
        transactions1.setCreditorAgent(transactions.getCreditorAgent());
        transactions1.setUltimateCreditor(transactions.getUltimateCreditor());
        transactions1.setDebtorName(transactions.getDebtorName());
        transactions1.setDebtorAccount(this.mapToAccountReference(transactions.getDebtorAccount()));
        transactions1.setDebtorAgent(transactions.getDebtorAgent());
        transactions1.setUltimateDebtor(transactions.getUltimateDebtor());
        transactions1.setRemittanceInformationUnstructured(transactions.getRemittanceInformationUnstructured());
        transactions1.setRemittanceInformationUnstructuredArray(this.stringListToRemittanceInformationUnstructuredArray(transactions.getRemittanceInformationUnstructuredArray()));
        transactions1.setRemittanceInformationStructured(transactions.getRemittanceInformationStructured());
        transactions1.setRemittanceInformationStructuredArray(this.stringListToRemittanceInformationStructuredArray(transactions.getRemittanceInformationStructuredArray()));
        transactions1.setAdditionalInformation(transactions.getAdditionalInformation());
        transactions1.setAdditionalInformationStructured(this.xs2aAdditionalInformationStructuredToAdditionalInformationStructured(transactions.getAdditionalInformationStructured()));
        transactions1.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(transactions.getPurposeCode()));
        transactions1.setProprietaryBankTransactionCode(transactions.getProprietaryBankTransactionCode());
        transactions1.setBalanceAfterTransaction(this.mapToBalance(transactions.getBalanceAfterTransaction()));
        transactions1.setCurrencyExchange(this.mapToReportExchanges(transactions.getExchangeRate()));
        return transactions1;
    }

    @Override
    protected ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate xs2aExchangeRate) {
        if (xs2aExchangeRate == null) {
            return null;
        }
        ReportExchangeRate reportExchangeRate = new ReportExchangeRate();
        reportExchangeRate.setSourceCurrency(xs2aExchangeRate.getSourceCurrency());
        reportExchangeRate.setExchangeRate(xs2aExchangeRate.getExchangeRate());
        reportExchangeRate.setUnitCurrency(xs2aExchangeRate.getUnitCurrency());
        reportExchangeRate.setTargetCurrency(xs2aExchangeRate.getTargetCurrency());
        reportExchangeRate.setQuotationDate(xs2aExchangeRate.getQuotationDate());
        reportExchangeRate.setContractIdentification(xs2aExchangeRate.getContractIdentification());
        return reportExchangeRate;
    }

    private String accountReferenceCurrencyCurrencyCode(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        Currency currency = accountReference.getCurrency();
        if (currency == null) {
            return null;
        }
        String currencyCode = currency.getCurrencyCode();
        if (currencyCode == null) {
            return null;
        }
        return currencyCode;
    }

    protected AccountDetails.UsageEnum xs2aUsageTypeToUsageEnum(Xs2aUsageType xs2aUsageType) {
        AccountDetails.UsageEnum usageEnum;
        if (xs2aUsageType == null) {
            return null;
        }
        switch (xs2aUsageType) {
            case PRIV: {
                usageEnum = AccountDetails.UsageEnum.PRIV;
                break;
            }
            case ORGA: {
                usageEnum = AccountDetails.UsageEnum.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + xs2aUsageType);
            }
        }
        return usageEnum;
    }

    protected AccountStatus accountStatusToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        AccountStatus accountStatus1;
        if (accountStatus == null) {
            return null;
        }
        switch (accountStatus) {
            case ENABLED: {
                accountStatus1 = AccountStatus.ENABLED;
                break;
            }
            case DELETED: {
                accountStatus1 = AccountStatus.DELETED;
                break;
            }
            case BLOCKED: {
                accountStatus1 = AccountStatus.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountStatus);
            }
        }
        return accountStatus1;
    }

    private String transactionsBankTransactionCodeCodeCode(Transactions transactions) {
        if (transactions == null) {
            return null;
        }
        BankTransactionCode bankTransactionCodeCode = transactions.getBankTransactionCodeCode();
        if (bankTransactionCodeCode == null) {
            return null;
        }
        String code = bankTransactionCodeCode.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }

    protected RemittanceInformationUnstructuredArray stringListToRemittanceInformationUnstructuredArray(List<String> list) {
        if (list == null) {
            return null;
        }
        RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray = new RemittanceInformationUnstructuredArray();
        for (String string : list) {
            remittanceInformationUnstructuredArray.add((Object)string);
        }
        return remittanceInformationUnstructuredArray;
    }

    protected RemittanceInformationStructuredArray stringListToRemittanceInformationStructuredArray(List<String> list) {
        if (list == null) {
            return null;
        }
        RemittanceInformationStructuredArray remittanceInformationStructuredArray = new RemittanceInformationStructuredArray();
        for (String string : list) {
            remittanceInformationStructuredArray.add((Object)string);
        }
        return remittanceInformationStructuredArray;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        FrequencyCode frequencyCode1;
        if (frequencyCode == null) {
            return null;
        }
        switch (frequencyCode) {
            case DAILY: {
                frequencyCode1 = FrequencyCode.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCode1 = FrequencyCode.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCode1 = FrequencyCode.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCode1 = FrequencyCode.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCode1 = FrequencyCode.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCode1 = FrequencyCode.ANNUAL;
                break;
            }
            case MONTHLYVARIABLE: {
                frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCode);
            }
        }
        return frequencyCode1;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        ExecutionRule executionRule;
        if (pisExecutionRule == null) {
            return null;
        }
        switch (pisExecutionRule) {
            case FOLLOWING: {
                executionRule = ExecutionRule.FOLLOWING;
                break;
            }
            case PRECEDING: {
                executionRule = ExecutionRule.PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + pisExecutionRule);
            }
        }
        return executionRule;
    }

    protected MonthsOfExecution stringListToMonthsOfExecution(List<String> list) {
        if (list == null) {
            return null;
        }
        MonthsOfExecution monthsOfExecution = new MonthsOfExecution();
        for (String string : list) {
            monthsOfExecution.add((Object)string);
        }
        return monthsOfExecution;
    }

    protected StandingOrderDetails xs2aStandingOrderDetailsToStandingOrderDetails(Xs2aStandingOrderDetails xs2aStandingOrderDetails) {
        if (xs2aStandingOrderDetails == null) {
            return null;
        }
        StandingOrderDetails standingOrderDetails = new StandingOrderDetails();
        standingOrderDetails.setStartDate(xs2aStandingOrderDetails.getStartDate());
        standingOrderDetails.setFrequency(this.frequencyCodeToFrequencyCode(xs2aStandingOrderDetails.getFrequency()));
        standingOrderDetails.setEndDate(xs2aStandingOrderDetails.getEndDate());
        standingOrderDetails.setExecutionRule(this.pisExecutionRuleToExecutionRule(xs2aStandingOrderDetails.getExecutionRule()));
        standingOrderDetails.setWithinAMonthFlag(xs2aStandingOrderDetails.getWithinAMonthFlag());
        standingOrderDetails.setMonthsOfExecution(this.stringListToMonthsOfExecution(xs2aStandingOrderDetails.getMonthsOfExecution()));
        standingOrderDetails.setMultiplicator(xs2aStandingOrderDetails.getMultiplicator());
        standingOrderDetails.setLimitAmount(this.amountModelMapper.mapToAmount(xs2aStandingOrderDetails.getLimitAmount()));
        standingOrderDetails.setDayOfExecution(this.mapDayOfExecution(xs2aStandingOrderDetails.getDayOfExecution()));
        return standingOrderDetails;
    }

    protected AdditionalInformationStructured xs2aAdditionalInformationStructuredToAdditionalInformationStructured(Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured) {
        if (xs2aAdditionalInformationStructured == null) {
            return null;
        }
        AdditionalInformationStructured additionalInformationStructured = new AdditionalInformationStructured();
        additionalInformationStructured.setStandingOrderDetails(this.xs2aStandingOrderDetailsToStandingOrderDetails(xs2aAdditionalInformationStructured.getStandingOrderDetails()));
        return additionalInformationStructured;
    }
}

