/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.GetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.payment.PaymentServiceResolver;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.payment.cancel.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.read.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.status.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CancelPaymentPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CancelPaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CreatePaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentByIdPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentStatusByIdPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentStatusByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.dto.CreatePaymentRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentAfterSpiService;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final RequestProviderService requestProviderService;
    private final CreatePaymentValidator createPaymentValidator;
    private final GetPaymentByIdValidator getPaymentByIdValidator;
    private final GetPaymentStatusByIdValidator getPaymentStatusByIdValidator;
    private final CancelPaymentValidator cancelPaymentValidator;
    private final PaymentServiceResolver paymentServiceResolver;
    private final LoggingContextService loggingContextService;
    private final ScaApproachResolver scaApproachResolver;

    public ResponseObject<PaymentInitiationResponse> createPayment(byte[] payment, PaymentInitiationParameters paymentInitiationParameters) {
        this.xs2aEventService.recordTppRequest(EventType.PAYMENT_INITIATION_REQUEST_RECEIVED, payment);
        CreatePaymentRequestObject createPaymentRequestObject = new CreatePaymentRequestObject(payment, paymentInitiationParameters);
        ValidationResult validationResult = this.createPaymentValidator.validate(createPaymentRequestObject);
        if (validationResult.isNotValid()) {
            log.info("PaymentType [{}], PaymentProduct [{}]. Create payment - validation failed: [{}]", new Object[]{paymentInitiationParameters.getPaymentType(), paymentInitiationParameters.getPaymentProduct(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (this.isNotSupportedScaApproach(this.scaApproachResolver.resolveScaApproach())) {
            throw new UnsupportedOperationException("Unsupported operation");
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        CreatePaymentService createPaymentService = this.paymentServiceResolver.getCreatePaymentService(paymentInitiationParameters);
        ResponseObject<PaymentInitiationResponse> responseObject = createPaymentService.createPayment(payment, paymentInitiationParameters, tppInfo);
        if (responseObject.hasError()) {
            log.info("Create payment failed: [{}]", (Object)responseObject.getError());
            return ResponseObject.builder().fail(responseObject.getError()).build();
        }
        PaymentInitiationResponse paymentInitiationResponse = responseObject.getBody();
        paymentInitiationResponse.setTppMessageInformation(this.createPaymentValidator.buildWarningMessages(createPaymentRequestObject));
        this.loggingContextService.storeTransactionAndScaStatus(paymentInitiationResponse.getTransactionStatus(), paymentInitiationResponse.getScaStatus());
        return ResponseObject.builder().body(paymentInitiationResponse).build();
    }

    public ResponseObject<CommonPayment> getPaymentById(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.GET_PAYMENT_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (pisCommonPaymentOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Get payment failed. PIS CommonPayment not found by ID", (Object)encryptedPaymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        PisCommonPaymentResponse commonPaymentResponse = pisCommonPaymentOptional.get();
        ValidationResult validationResult = this.getPaymentByIdValidator.validate(new GetPaymentByIdPO(commonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get payment - validation failed: {}", (Object)encryptedPaymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PsuIdData psuIdData = this.getPsuIdDataFromRequest();
        ReadPaymentService readPaymentService = this.paymentServiceResolver.getReadPaymentService((CommonPaymentData)commonPaymentResponse);
        String contentType = Optional.ofNullable(commonPaymentResponse.getContentType()).orElseGet(this.requestProviderService::getAcceptHeader);
        commonPaymentResponse.setContentType(contentType);
        PaymentInformationResponse<CommonPayment> response = readPaymentService.getPayment((CommonPaymentData)commonPaymentResponse, psuIdData, encryptedPaymentId, contentType);
        if (response.hasError()) {
            log.info("Payment-ID [{}]. Read Payment failed: {}", (Object)encryptedPaymentId, (Object)response.getErrorHolder());
            return ResponseObject.builder().fail(response.getErrorHolder()).build();
        }
        CommonPayment commonPayment = response.getPayment();
        String responseContentType = this.resolveContentType(contentType, commonPayment.getContentType());
        commonPayment.setContentType(responseContentType);
        this.loggingContextService.storeTransactionStatus(commonPayment.getTransactionStatus());
        return ResponseObject.builder().body(commonPayment).build();
    }

    public ResponseObject<GetPaymentStatusResponse> getPaymentStatusById(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.GET_TRANSACTION_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (pisCommonPaymentOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Get Payment Status failed. PIS CommonPayment not found by ID", (Object)encryptedPaymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        ValidationResult validationResult = this.getPaymentStatusByIdValidator.validate(new GetPaymentStatusByIdPO(pisCommonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get payment status by ID - validation failed: {}", (Object)encryptedPaymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().body(new GetPaymentStatusResponse(TransactionStatus.RJCT, null, MediaType.APPLICATION_JSON, null, null)).build();
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(this.getPsuIdDataFromRequest());
        ReadPaymentStatusService readPaymentStatusService = this.paymentServiceResolver.getReadPaymentStatusService(pisCommonPaymentResponse);
        ReadPaymentStatusResponse readPaymentStatusResponse = readPaymentStatusService.readPaymentStatus((CommonPaymentData)pisCommonPaymentResponse, spiContextData, encryptedPaymentId, this.requestProviderService.getAcceptHeader());
        if (readPaymentStatusResponse.hasError()) {
            ErrorHolder errorHolder = readPaymentStatusResponse.getErrorHolder();
            log.info("Payment-ID [{}]. Read Payment status failed: {}", (Object)encryptedPaymentId, (Object)errorHolder);
            return ResponseObject.builder().fail(errorHolder).build();
        }
        TransactionStatus transactionStatus = readPaymentStatusResponse.getStatus();
        if (transactionStatus == null) {
            log.info("Payment-ID [{}].  Get Payment Status by ID failed. Transaction status is null.", (Object)encryptedPaymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        if (!this.updatePaymentAfterSpiService.updatePaymentStatus(encryptedPaymentId, transactionStatus)) {
            log.info("Payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", (Object)encryptedPaymentId, (Object)transactionStatus);
        }
        this.loggingContextService.storeTransactionStatus(transactionStatus);
        GetPaymentStatusResponse response = new GetPaymentStatusResponse(transactionStatus, readPaymentStatusResponse.getFundsAvailable(), readPaymentStatusResponse.getResponseContentType(), readPaymentStatusResponse.getPaymentStatusRaw(), readPaymentStatusResponse.getPsuMessage());
        return ResponseObject.builder().body(response).build();
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(PisPaymentCancellationRequest paymentCancellationRequest) {
        this.xs2aEventService.recordPisTppRequest(paymentCancellationRequest.getEncryptedPaymentId(), EventType.PAYMENT_CANCELLATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentCancellationRequest.getEncryptedPaymentId());
        if (pisCommonPaymentOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Cancel payment has failed. Payment not found by ID.", (Object)paymentCancellationRequest.getEncryptedPaymentId());
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        CancelPaymentPO cancelPaymentPO = new CancelPaymentPO(pisCommonPaymentResponse, paymentCancellationRequest.getPaymentType(), paymentCancellationRequest.getPaymentProduct(), paymentCancellationRequest.getTppRedirectUri());
        ValidationResult validationResult = this.cancelPaymentValidator.validate(cancelPaymentPO);
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Cancel payment - validation failed: [{}]", (Object)paymentCancellationRequest.getEncryptedPaymentId(), (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (pisCommonPaymentResponse.getTransactionStatus().isFinalisedStatus()) {
            log.info("Payment-ID [{}]. Cancel payment has failed. Payment has finalised status", (Object)paymentCancellationRequest.getEncryptedPaymentId());
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_BLOCKED)).build();
        }
        CancelPaymentService cancelPaymentService = this.paymentServiceResolver.getCancelPaymentService(paymentCancellationRequest);
        ResponseObject<CancelPaymentResponse> responseObject = cancelPaymentService.cancelPayment((CommonPaymentData)pisCommonPaymentResponse, paymentCancellationRequest);
        if (responseObject.hasError()) {
            log.info("Payment-ID: [{}]. Cancel payment failed: [{}]", (Object)paymentCancellationRequest.getEncryptedPaymentId(), (Object)responseObject.getError());
            return ResponseObject.builder().fail(responseObject.getError()).build();
        }
        CancelPaymentResponse cancelPaymentResponse = responseObject.getBody();
        cancelPaymentResponse.setTppMessageInformation(this.cancelPaymentValidator.buildWarningMessages(cancelPaymentPO));
        this.loggingContextService.storeTransactionStatus(cancelPaymentResponse.getTransactionStatus());
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    private PsuIdData getPsuIdDataFromRequest() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return psuIdData;
    }

    private boolean isNotSupportedScaApproach(ScaApproach scaApproach) {
        return !EnumSet.of(ScaApproach.REDIRECT, ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach);
    }

    private String resolveContentType(String contentTypeBeforeSpi, String contentTypeAfterSpi) {
        String responseContentType = (String)StringUtils.defaultIfBlank((CharSequence)contentTypeAfterSpi, (CharSequence)contentTypeBeforeSpi);
        if ("*/*".equals(responseContentType)) {
            responseContentType = "application/json";
        }
        return responseContentType;
    }

    @ConstructorProperties(value={"pisCommonPaymentService", "updatePaymentAfterSpiService", "tppService", "xs2aEventService", "spiContextDataProvider", "requestProviderService", "createPaymentValidator", "getPaymentByIdValidator", "getPaymentStatusByIdValidator", "cancelPaymentValidator", "paymentServiceResolver", "loggingContextService", "scaApproachResolver"})
    public PaymentService(Xs2aPisCommonPaymentService pisCommonPaymentService, Xs2aUpdatePaymentAfterSpiService updatePaymentAfterSpiService, TppService tppService, Xs2aEventService xs2aEventService, SpiContextDataProvider spiContextDataProvider, RequestProviderService requestProviderService, CreatePaymentValidator createPaymentValidator, GetPaymentByIdValidator getPaymentByIdValidator, GetPaymentStatusByIdValidator getPaymentStatusByIdValidator, CancelPaymentValidator cancelPaymentValidator, PaymentServiceResolver paymentServiceResolver, LoggingContextService loggingContextService, ScaApproachResolver scaApproachResolver) {
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.updatePaymentAfterSpiService = updatePaymentAfterSpiService;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.requestProviderService = requestProviderService;
        this.createPaymentValidator = createPaymentValidator;
        this.getPaymentByIdValidator = getPaymentByIdValidator;
        this.getPaymentStatusByIdValidator = getPaymentStatusByIdValidator;
        this.cancelPaymentValidator = cancelPaymentValidator;
        this.paymentServiceResolver = paymentServiceResolver;
        this.loggingContextService = loggingContextService;
        this.scaApproachResolver = scaApproachResolver;
    }
}

