/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class AdditionalInformationSupportedService {
    private final AspspProfileServiceWrapper aspspProfileService;

    public CreateConsentReq checkIfAdditionalInformationSupported(CreateConsentReq request) {
        AccountAccess access;
        AdditionalInformationAccess additionalInformationAccess;
        boolean isOwnerNameSupported = this.aspspProfileService.isAccountOwnerInformationSupported();
        boolean isTrustedBeneficiariesSupported = this.aspspProfileService.isTrustedBeneficiariesSupported();
        if (!isOwnerNameSupported) {
            this.clearAccountAccessType(request);
        }
        if (!(isOwnerNameSupported && isTrustedBeneficiariesSupported || (additionalInformationAccess = (access = request.getAccess()).getAdditionalInformationAccess()) == null)) {
            AdditionalInformationAccess additionalInformationCleaned = new AdditionalInformationAccess(isOwnerNameSupported ? additionalInformationAccess.getOwnerName() : null, isTrustedBeneficiariesSupported ? additionalInformationAccess.getTrustedBeneficiaries() : null);
            request.setAccess(new AccountAccess(access.getAccounts(), access.getBalances(), access.getTransactions(), additionalInformationCleaned));
        }
        return request;
    }

    private CreateConsentReq clearAccountAccessType(CreateConsentReq request) {
        if (request.getAvailableAccounts() == AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAvailableAccounts(AccountAccessType.ALL_ACCOUNTS);
        }
        if (request.getAvailableAccountsWithBalance() == AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAvailableAccountsWithBalance(AccountAccessType.ALL_ACCOUNTS);
        }
        if (request.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAllPsd2(AccountAccessType.ALL_ACCOUNTS);
        }
        return request;
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AdditionalInformationSupportedService(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

