/*
 * Copyright 2018-2019 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.web.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * Converter, responsible for properly mapping incoming String in request parameters into LocalDate instance.
 * Applied globally for all controllers.
 * Used primarily in {@link de.adorsys.psd2.api.AccountApi#getTransactionList} and
 * {@link de.adorsys.psd2.api.CardAccountsApi#getCardAccountTransactionList}
 */
@Component
public class LocalDateConverter implements Converter<String, LocalDate> {
    @Override
    public LocalDate convert(String source) {
        return convert(source, DateTimeFormatter.ISO_DATE);
    }

    public LocalDate convert(String source, DateTimeFormatter formatter) {
        return LocalDate.parse(source, formatter);
    }
}
