/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TppRedirectUriBodyValidatorImpl
implements BodyValidator {
    private final ScaApproachResolver scaApproachResolver;
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final ErrorBuildingService errorBuildingService;

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        if (this.isRedirectScaApproach()) {
            String tppRedirectUriHeader = request.getHeader("tpp-redirect-uri");
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(String::toLowerCase, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            if (!headers.containsKey("tpp-redirect-uri")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_ABSENT_HEADER, (Object[])new Object[]{"tpp-redirect-uri"}));
            } else if (tppRedirectUriHeader == null) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_HEADER, (Object[])new Object[]{"tpp-redirect-uri"}));
            } else if (StringUtils.isBlank((CharSequence)tppRedirectUriHeader)) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_BLANK_HEADER, (Object[])new Object[]{"tpp-redirect-uri"}));
            }
        }
        return messageError;
    }

    private boolean isRedirectScaApproach() {
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        return ScaApproach.REDIRECT == scaApproach && this.aspspProfileServiceWrapper.getScaRedirectFlow().equals((Object)ScaRedirectFlow.REDIRECT);
    }

    @ConstructorProperties(value={"scaApproachResolver", "aspspProfileServiceWrapper", "errorBuildingService"})
    public TppRedirectUriBodyValidatorImpl(ScaApproachResolver scaApproachResolver, AspspProfileServiceWrapper aspspProfileServiceWrapper, ErrorBuildingService errorBuildingService) {
        this.scaApproachResolver = scaApproachResolver;
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.errorBuildingService = errorBuildingService;
    }
}

