/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.logger.context.RequestInfo;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Priority(value=0)
@Component
public class Xs2aLoggingContextFilter
extends AbstractXs2aFilter {
    private final LoggingContextService loggingContextService;
    private final RequestProviderService requestProviderService;

    public Xs2aLoggingContextFilter(TppErrorMessageWriter tppErrorMessageWriter, Xs2aEndpointChecker xs2aEndpointChecker, LoggingContextService loggingContextService, RequestProviderService requestProviderService) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.loggingContextService = loggingContextService;
        this.requestProviderService = requestProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternalCustom(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestInfo requestInfo = new RequestInfo(this.requestProviderService.getInternalRequestIdString(), this.requestProviderService.getRequestIdString(), this.requestProviderService.getInstanceId());
        this.loggingContextService.storeRequestInformation(requestInfo);
        try {
            this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
        finally {
            this.loggingContextService.clearContext();
        }
    }
}

