/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationPsuDataChecker;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStatusChecker;
import de.adorsys.psd2.xs2a.service.validator.piis.AbstractConfirmationOfFundsConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentAuthorisationObject;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreatePiisConsentAuthorisationValidator
extends AbstractConfirmationOfFundsConsentTppValidator<CreatePiisConsentAuthorisationObject> {
    private final AuthorisationPsuDataChecker authorisationPsuDataChecker;
    private final AuthorisationStatusChecker authorisationStatusChecker;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CreatePiisConsentAuthorisationObject createPiisConsentAuthorisationObject) {
        PsuIdData psuDataFromRequest = createPiisConsentAuthorisationObject.getPsuIdDataFromRequest();
        PiisConsent piisConsent = createPiisConsentAuthorisationObject.getPiisConsent();
        List psuDataFromDb = piisConsent.getPsuIdDataList();
        if (this.authorisationPsuDataChecker.isPsuDataWrong(piisConsent.isMultilevelScaRequired(), psuDataFromDb, psuDataFromRequest)) {
            return ValidationResult.invalid(ErrorType.PIIS_401, MessageErrorCode.PSU_CREDENTIALS_INVALID);
        }
        List accountConsentAuthorisations = piisConsent.getAuthorisations();
        List<Authorisation> authorisations = accountConsentAuthorisations.stream().map(auth -> new Authorisation(auth.getId(), auth.getPsuIdData(), auth.getConsentId(), AuthorisationType.CONSENT, auth.getScaStatus())).collect(Collectors.toList());
        boolean isFinalised = this.authorisationStatusChecker.isFinalised(psuDataFromRequest, authorisations, AuthorisationType.CONSENT);
        if (isFinalised) {
            return ValidationResult.invalid(ErrorType.PIIS_409, MessageErrorCode.STATUS_INVALID);
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"authorisationPsuDataChecker", "authorisationStatusChecker"})
    public CreatePiisConsentAuthorisationValidator(AuthorisationPsuDataChecker authorisationPsuDataChecker, AuthorisationStatusChecker authorisationStatusChecker) {
        this.authorisationPsuDataChecker = authorisationPsuDataChecker;
        this.authorisationStatusChecker = authorisationStatusChecker;
    }
}

