/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTrustedBeneficiaries;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aTrustedBeneficiariesMapper {
    private final SpiToXs2aAccountReferenceMapper accountReferenceMapper;
    private final SpiToXs2aAddressMapper addressMapper;

    public Xs2aTrustedBeneficiaries mapToXs2aTrustedBeneficiaries(SpiTrustedBeneficiaries spiTrustedBeneficiaries) {
        return Optional.ofNullable(spiTrustedBeneficiaries).map(tb -> new Xs2aTrustedBeneficiaries(tb.getTrustedBeneficiaryId(), this.accountReferenceMapper.mapToXs2aAccountReference(tb.getDebtorAccount()), this.accountReferenceMapper.mapToXs2aAccountReference(tb.getCreditorAccount()), tb.getCreditorAgent(), tb.getCreditorName(), tb.getCreditorAlias(), tb.getCreditorId(), this.addressMapper.mapToAddress(tb.getCreditorAddress()))).orElse(null);
    }

    public List<Xs2aTrustedBeneficiaries> mapToXs2aTrustedBeneficiariesList(List<SpiTrustedBeneficiaries> spiTrustedBeneficiaries) {
        if (CollectionUtils.isEmpty(spiTrustedBeneficiaries)) {
            return new ArrayList<Xs2aTrustedBeneficiaries>();
        }
        return spiTrustedBeneficiaries.stream().map(this::mapToXs2aTrustedBeneficiaries).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"accountReferenceMapper", "addressMapper"})
    public SpiToXs2aTrustedBeneficiariesMapper(SpiToXs2aAccountReferenceMapper accountReferenceMapper, SpiToXs2aAddressMapper addressMapper) {
        this.accountReferenceMapper = accountReferenceMapper;
        this.addressMapper = addressMapper;
    }
}

