/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiariesList;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTrustedBeneficiariesMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetTrustedBeneficiariesListValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetTrustedBeneficiariesListConsentObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrustedBeneficiariesService {
    private static final Logger log = LoggerFactory.getLogger(TrustedBeneficiariesService.class);
    private final AccountSpi accountSpi;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetTrustedBeneficiariesListValidator getTrustedBeneficiariesListValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;
    private final SpiToXs2aTrustedBeneficiariesMapper spiToXs2aTrustedBeneficiariesMapper;

    public ResponseObject<Xs2aTrustedBeneficiariesList> getTrustedBeneficiaries(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.READ_TRUSTED_BENEFICIARIES_LIST_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            return this.getResponseWithNotFoundConsent(consentId, accountId);
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getValidationResult(accountId, requestUri, aisConsent);
        if (validationResult.isNotValid()) {
            return this.getResponseWithValidationError(consentId, accountId, requestUri, validationResult);
        }
        SpiResponse<List<SpiTrustedBeneficiaries>> spiResponse = this.getSpiResponse(aisConsent, consentId, accountId);
        if (spiResponse.hasError()) {
            return this.getResponseWithSpiError(consentId, spiResponse);
        }
        return this.getSuccessfulResponse(consentId, accountId, requestUri, aisConsent, spiResponse);
    }

    private ResponseObject<Xs2aTrustedBeneficiariesList> getResponseWithNotFoundConsent(String consentId, String accountId) {
        log.info("Account-ID [{}], Consent-ID [{}]. Get trusted beneficiaries list failed. Account consent not found by id", (Object)accountId, (Object)consentId);
        return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
    }

    private ValidationResult getValidationResult(String accountId, String requestUri, AisConsent aisConsent) {
        GetTrustedBeneficiariesListConsentObject validatorObject = new GetTrustedBeneficiariesListConsentObject(aisConsent, accountId, requestUri);
        return this.getTrustedBeneficiariesListValidator.validate(validatorObject);
    }

    private ResponseObject<Xs2aTrustedBeneficiariesList> getResponseWithValidationError(String consentId, String accountId, String requestUri, ValidationResult validationResult) {
        log.info("Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get trusted beneficiaries list - validation failed: {}", new Object[]{accountId, consentId, requestUri, validationResult.getMessageError()});
        return ResponseObject.builder().fail(validationResult.getMessageError()).build();
    }

    private SpiResponse<List<SpiTrustedBeneficiaries>> getSpiResponse(AisConsent aisConsent, String consentId, String accountId) {
        return this.accountSpi.requestTrustedBeneficiariesList(this.accountHelperService.getSpiContextData(), this.accountHelperService.findAccountReference(aisConsent.getAspspAccountAccesses().getAccounts(), accountId), this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Xs2aTrustedBeneficiariesList> getResponseWithSpiError(String consentId, SpiResponse<List<SpiTrustedBeneficiaries>> spiResponse) {
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("Consent-ID: [{}]. Get trusted beneficiaries list failed: couldn't get trusted beneficiaries. Error msg: [{}]", (Object)consentId, (Object)errorHolder);
        return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
    }

    private ResponseObject<Xs2aTrustedBeneficiariesList> getSuccessfulResponse(String consentId, String accountId, String requestUri, AisConsent aisConsent, SpiResponse<List<SpiTrustedBeneficiaries>> spiResponse) {
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        List<Xs2aTrustedBeneficiaries> trustedBeneficiaries = this.spiToXs2aTrustedBeneficiariesMapper.mapToXs2aTrustedBeneficiariesList((List)spiResponse.getPayload());
        Xs2aTrustedBeneficiariesList xs2aTrustedBeneficiariesList = new Xs2aTrustedBeneficiariesList(trustedBeneficiaries);
        ResponseObject<Xs2aTrustedBeneficiariesList> response = ResponseObject.builder().body(xs2aTrustedBeneficiariesList).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.BENEFICIARIES, response), requestUri, this.accountHelperService.needsToUpdateUsage(aisConsent), accountId, null);
        return response;
    }

    @ConstructorProperties(value={"accountSpi", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "spiErrorMapper", "getTrustedBeneficiariesListValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService", "spiToXs2aTrustedBeneficiariesMapper"})
    public TrustedBeneficiariesService(AccountSpi accountSpi, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetTrustedBeneficiariesListValidator getTrustedBeneficiariesListValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService, SpiToXs2aTrustedBeneficiariesMapper spiToXs2aTrustedBeneficiariesMapper) {
        this.accountSpi = accountSpi;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getTrustedBeneficiariesListValidator = getTrustedBeneficiariesListValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
        this.spiToXs2aTrustedBeneficiariesMapper = spiToXs2aTrustedBeneficiariesMapper;
    }
}

