/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.model.ChargeBearer;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class SinglePayment
extends CommonPayment
implements AccountReferenceCollector {
    private String endToEndIdentification;
    private String instructionIdentification;
    @NotNull
    private AccountReference debtorAccount;
    private String ultimateDebtor;
    @Valid
    @NotNull
    private Xs2aAmount instructedAmount;
    @NotNull
    private AccountReference creditorAccount;
    private String creditorAgent;
    @NotNull
    private String creditorName;
    @Valid
    private Xs2aAddress creditorAddress;
    private String ultimateCreditor;
    private PurposeCode purposeCode;
    @Size(max=140)
    private @Size(max=140) String remittanceInformationUnstructured;
    @Valid
    private String remittanceInformationStructured;
    private List<String> remittanceInformationStructuredArray;
    private LocalDate requestedExecutionDate;
    private OffsetDateTime requestedExecutionTime;
    private String debtorName;
    private ChargeBearer chargeBearer;
    protected PaymentType paymentType = PaymentType.SINGLE;

    @Override
    @JsonIgnore
    public Set<AccountReference> getAccountReferences() {
        return new HashSet<AccountReference>(Arrays.asList(this.debtorAccount, this.creditorAccount));
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SINGLE;
    }

    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public Xs2aAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public Xs2aAddress getCreditorAddress() {
        return this.creditorAddress;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public List<String> getRemittanceInformationStructuredArray() {
        return this.remittanceInformationStructuredArray;
    }

    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public ChargeBearer getChargeBearer() {
        return this.chargeBearer;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setInstructedAmount(Xs2aAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAddress(Xs2aAddress creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setRemittanceInformationStructuredArray(List<String> remittanceInformationStructuredArray) {
        this.remittanceInformationStructuredArray = remittanceInformationStructuredArray;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setChargeBearer(ChargeBearer chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    @Override
    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinglePayment)) {
            return false;
        }
        SinglePayment other = (SinglePayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$endToEndIdentification = this.getEndToEndIdentification();
        String other$endToEndIdentification = other.getEndToEndIdentification();
        if (this$endToEndIdentification == null ? other$endToEndIdentification != null : !this$endToEndIdentification.equals(other$endToEndIdentification)) {
            return false;
        }
        String this$instructionIdentification = this.getInstructionIdentification();
        String other$instructionIdentification = other.getInstructionIdentification();
        if (this$instructionIdentification == null ? other$instructionIdentification != null : !this$instructionIdentification.equals(other$instructionIdentification)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        Xs2aAmount this$instructedAmount = this.getInstructedAmount();
        Xs2aAmount other$instructedAmount = other.getInstructedAmount();
        if (this$instructedAmount == null ? other$instructedAmount != null : !this$instructedAmount.equals(other$instructedAmount)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !this$creditorAccount.equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        Xs2aAddress this$creditorAddress = this.getCreditorAddress();
        Xs2aAddress other$creditorAddress = other.getCreditorAddress();
        if (this$creditorAddress == null ? other$creditorAddress != null : !this$creditorAddress.equals(other$creditorAddress)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        PurposeCode this$purposeCode = this.getPurposeCode();
        PurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        String this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        String other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !this$remittanceInformationStructured.equals(other$remittanceInformationStructured)) {
            return false;
        }
        List<String> this$remittanceInformationStructuredArray = this.getRemittanceInformationStructuredArray();
        List<String> other$remittanceInformationStructuredArray = other.getRemittanceInformationStructuredArray();
        if (this$remittanceInformationStructuredArray == null ? other$remittanceInformationStructuredArray != null : !((Object)this$remittanceInformationStructuredArray).equals(other$remittanceInformationStructuredArray)) {
            return false;
        }
        LocalDate this$requestedExecutionDate = this.getRequestedExecutionDate();
        LocalDate other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !((Object)this$requestedExecutionDate).equals(other$requestedExecutionDate)) {
            return false;
        }
        OffsetDateTime this$requestedExecutionTime = this.getRequestedExecutionTime();
        OffsetDateTime other$requestedExecutionTime = other.getRequestedExecutionTime();
        if (this$requestedExecutionTime == null ? other$requestedExecutionTime != null : !((Object)this$requestedExecutionTime).equals(other$requestedExecutionTime)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        ChargeBearer this$chargeBearer = this.getChargeBearer();
        ChargeBearer other$chargeBearer = other.getChargeBearer();
        if (this$chargeBearer == null ? other$chargeBearer != null : !this$chargeBearer.equals(other$chargeBearer)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        return !(this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SinglePayment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $endToEndIdentification = this.getEndToEndIdentification();
        result = result * 59 + ($endToEndIdentification == null ? 43 : $endToEndIdentification.hashCode());
        String $instructionIdentification = this.getInstructionIdentification();
        result = result * 59 + ($instructionIdentification == null ? 43 : $instructionIdentification.hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        Xs2aAmount $instructedAmount = this.getInstructedAmount();
        result = result * 59 + ($instructedAmount == null ? 43 : $instructedAmount.hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : $creditorAccount.hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        Xs2aAddress $creditorAddress = this.getCreditorAddress();
        result = result * 59 + ($creditorAddress == null ? 43 : $creditorAddress.hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        PurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        String $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : $remittanceInformationStructured.hashCode());
        List<String> $remittanceInformationStructuredArray = this.getRemittanceInformationStructuredArray();
        result = result * 59 + ($remittanceInformationStructuredArray == null ? 43 : ((Object)$remittanceInformationStructuredArray).hashCode());
        LocalDate $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : ((Object)$requestedExecutionDate).hashCode());
        OffsetDateTime $requestedExecutionTime = this.getRequestedExecutionTime();
        result = result * 59 + ($requestedExecutionTime == null ? 43 : ((Object)$requestedExecutionTime).hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        ChargeBearer $chargeBearer = this.getChargeBearer();
        result = result * 59 + ($chargeBearer == null ? 43 : $chargeBearer.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SinglePayment(super=" + super.toString() + ", endToEndIdentification=" + this.getEndToEndIdentification() + ", instructionIdentification=" + this.getInstructionIdentification() + ", debtorAccount=" + this.getDebtorAccount() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", instructedAmount=" + this.getInstructedAmount() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", creditorName=" + this.getCreditorName() + ", creditorAddress=" + this.getCreditorAddress() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", purposeCode=" + this.getPurposeCode() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", remittanceInformationStructuredArray=" + this.getRemittanceInformationStructuredArray() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", requestedExecutionTime=" + this.getRequestedExecutionTime() + ", debtorName=" + this.getDebtorName() + ", chargeBearer=" + this.getChargeBearer() + ", paymentType=" + this.getPaymentType() + ")";
    }
}

