/*
 * Copyright 2018-2020 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.domain.account;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.CustomContentTypeProvider;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;

import java.util.List;

@Data
public class Xs2aCardTransactionsReport implements CustomContentTypeProvider {

    private AccountReference accountReference;

    private Xs2aCardAccountReport cardAccountReport;

    private List<Xs2aBalance> balances;

    private Links links;

    private boolean transactionReportHuge;

    private String responseContentType;

    @Nullable
    private String downloadId;

    public boolean isResponseContentTypeJson() {
        return MediaType.APPLICATION_JSON_VALUE.equals(responseContentType);
    }

    @Override
    public MediaType getCustomContentType() {
        if (StringUtils.isBlank(responseContentType)) {
            return MediaType.APPLICATION_JSON;
        }
        return MediaType.parseMediaType(responseContentType);
    }
}
