/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aConsentService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedirectPiisAuthorizationService
implements PiisAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(RedirectPiisAuthorizationService.class);
    private final Xs2aPiisConsentService xs2aPiisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aConsentService consentService;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        Optional<PiisConsent> piisConsentOptional = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", (Object)consentId);
            return Optional.empty();
        }
        return this.consentService.createConsentAuthorisation(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            resp.setInternalRequestId(auth.getInternalRequestId());
            return resp;
        });
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        return null;
    }

    @Override
    public Optional<Authorisation> getConsentAuthorizationById(String authorizationId) {
        return this.authorisationService.getAuthorisationById(authorizationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.consentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.REDIRECT;
    }

    @ConstructorProperties(value={"xs2aPiisConsentService", "authorisationService", "consentService"})
    public RedirectPiisAuthorizationService(Xs2aPiisConsentService xs2aPiisConsentService, Xs2aAuthorisationService authorisationService, Xs2aConsentService consentService) {
        this.xs2aPiisConsentService = xs2aPiisConsentService;
        this.authorisationService = authorisationService;
        this.consentService = consentService;
    }
}

