package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.CardTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-12-17T11:01:04+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.9 (Azul Systems, Inc.)"
)
@Component
public class SpiToXs2aCardTransactionMapperImpl implements SpiToXs2aCardTransactionMapper {

    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private Xs2aToSpiAddressMapper xs2aToSpiAddressMapper;
    @Autowired
    private SpiToXs2aExchangeRateMapper spiToXs2aExchangeRateMapper;

    @Override
    public CardTransaction mapToXs2aCardTransaction(SpiCardTransaction spiCardTransaction) {
        if ( spiCardTransaction == null ) {
            return null;
        }

        CardTransaction cardTransaction = new CardTransaction();

        cardTransaction.setCardTransactionId( spiCardTransaction.getCardTransactionId() );
        cardTransaction.setTerminalId( spiCardTransaction.getTerminalId() );
        cardTransaction.setTransactionDate( spiCardTransaction.getTransactionDate() );
        cardTransaction.setAcceptorTransactionDateTime( spiCardTransaction.getAcceptorTransactionDateTime() );
        cardTransaction.setBookingDate( spiCardTransaction.getBookingDate() );
        cardTransaction.setTransactionAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiCardTransaction.getTransactionAmount() ) );
        cardTransaction.setCurrencyExchange( spiToXs2aExchangeRateMapper.mapToExchangeRateList( spiCardTransaction.getCurrencyExchange() ) );
        cardTransaction.setOriginalAmount( spiToXs2aAmountMapper.mapToXs2aAmount( spiCardTransaction.getOriginalAmount() ) );
        cardTransaction.setMarkupFee( spiToXs2aAmountMapper.mapToXs2aAmount( spiCardTransaction.getMarkupFee() ) );
        cardTransaction.setMarkupFeePercentage( spiCardTransaction.getMarkupFeePercentage() );
        cardTransaction.setCardAcceptorId( spiCardTransaction.getCardAcceptorId() );
        cardTransaction.setCardAcceptorAddress( xs2aToSpiAddressMapper.mapToXs2aAddress( spiCardTransaction.getCardAcceptorAddress() ) );
        cardTransaction.setCardAcceptorPhone( spiCardTransaction.getCardAcceptorPhone() );
        cardTransaction.setMerchantCategoryCode( spiCardTransaction.getMerchantCategoryCode() );
        cardTransaction.setMaskedPAN( spiCardTransaction.getMaskedPAN() );
        cardTransaction.setTransactionDetails( spiCardTransaction.getTransactionDetails() );
        cardTransaction.setInvoiced( spiCardTransaction.getInvoiced() );
        cardTransaction.setProprietaryBankTransactionCode( spiCardTransaction.getProprietaryBankTransactionCode() );

        return cardTransaction;
    }

    @Override
    public List<CardTransaction> mapToXs2aCardTransactionList(List<SpiCardTransaction> spiCardTransaction) {
        if ( spiCardTransaction == null ) {
            return null;
        }

        List<CardTransaction> list = new ArrayList<CardTransaction>( spiCardTransaction.size() );
        for ( SpiCardTransaction spiCardTransaction1 : spiCardTransaction ) {
            list.add( mapToXs2aCardTransaction( spiCardTransaction1 ) );
        }

        return list;
    }
}
