/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.DateFieldValidator;
import de.adorsys.psd2.xs2a.web.validator.body.TppRedirectUriBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.consent.ConsentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsentBodyFieldsValidatorImpl
extends AbstractBodyValidatorImpl
implements ConsentBodyValidator {
    private static final String ACCESS_FIELD_NAME = "access";
    private static final String ALL_PSD2_FIELD_NAME = "allPsd2";
    private static final String AVAILABLE_ACCOUNTS_FIELD_NAME = "availableAccounts";
    private static final String AVAILABLE_ACCOUNTS_WITH_BALANCES_FIELD_NAME = "availableAccountsWithBalance";
    private TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator;
    private DateFieldValidator dateFieldValidator;
    private FieldExtractor fieldExtractor;

    @Autowired
    public ConsentBodyFieldsValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, TppRedirectUriBodyValidatorImpl tppRedirectUriBodyValidator, DateFieldValidator dateFieldValidator, FieldExtractor fieldExtractor) {
        super(errorBuildingService, xs2aObjectMapper);
        this.dateFieldValidator = dateFieldValidator;
        this.tppRedirectUriBodyValidator = tppRedirectUriBodyValidator;
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public MessageError validateBodyFields(HttpServletRequest request, MessageError messageError) {
        this.tppRedirectUriBodyValidator.validate(request, messageError);
        this.validateRawAccess(request, messageError);
        Optional<Consents> consentsOptional = this.fieldExtractor.mapBodyToInstance(request, messageError, Consents.class);
        if (consentsOptional.isEmpty()) {
            return messageError;
        }
        Consents consents = consentsOptional.get();
        if (consents.getRecurringIndicator() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"recurringIndicator"}));
        }
        if (consents.getValidUntil() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"validUntil"}));
        } else {
            this.validateValidUntil(consents.getValidUntil(), messageError);
        }
        if (consents.getFrequencyPerDay() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"frequencyPerDay"}));
        } else {
            this.validateFrequencyPerDay(consents.getFrequencyPerDay(), messageError);
        }
        return messageError;
    }

    @Override
    public MessageError validateRawData(HttpServletRequest request, MessageError messageError) {
        this.validateRawAccess(request, messageError);
        return this.dateFieldValidator.validateDateFormat(request, Xs2aRequestBodyDateFields.AIS_CONSENT_DATE_FIELDS.getDateFields(), messageError);
    }

    private void validateValidUntil(LocalDate validUntil, MessageError messageError) {
        if (validUntil.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DATE_IN_THE_PAST, (Object[])new Object[]{"validUntil"}));
        }
    }

    private void validateFrequencyPerDay(Integer frequencyPerDay, MessageError messageError) {
        if (frequencyPerDay < 1) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FREQUENCY));
        }
    }

    private void validateRawAccess(HttpServletRequest request, MessageError messageError) {
        Map<String, Object> access = this.extractConsentAccessMap(request, messageError);
        Object allPsd2 = access.get(ALL_PSD2_FIELD_NAME);
        this.validateEnumValue(allPsd2, AccountAccess.AllPsd2Enum::fromValue, messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{ALL_PSD2_FIELD_NAME}));
        Object availableAccounts = access.get(AVAILABLE_ACCOUNTS_FIELD_NAME);
        this.validateEnumValue(availableAccounts, AccountAccess.AvailableAccountsEnum::fromValue, messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{AVAILABLE_ACCOUNTS_FIELD_NAME}));
        Object availableAccountsWithBalance = access.get(AVAILABLE_ACCOUNTS_WITH_BALANCES_FIELD_NAME);
        this.validateEnumValue(availableAccountsWithBalance, AccountAccess.AvailableAccountsWithBalanceEnum::fromValue, messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{AVAILABLE_ACCOUNTS_WITH_BALANCES_FIELD_NAME}));
    }

    private void validateEnumValue(Object value, Function<String, Enum> mapperToEnum, MessageError messageError, TppMessageInformation tppMessageInformation) {
        if (value == null || this.isValidEnumValue(value, mapperToEnum)) {
            return;
        }
        this.errorBuildingService.enrichMessageError(messageError, tppMessageInformation);
    }

    private boolean isValidEnumValue(@NotNull Object value, Function<String, Enum> mapperToEnum) {
        return value instanceof String && mapperToEnum.apply((String)value) != null;
    }

    private Map<String, Object> extractConsentAccessMap(HttpServletRequest request, MessageError messageError) {
        Optional access = Optional.empty();
        try {
            access = this.xs2aObjectMapper.toJsonField((InputStream)request.getInputStream(), ACCESS_FIELD_NAME, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
        }
        return access.orElseGet(Collections::emptyMap);
    }
}

