/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.web.validator.DefaultMethodValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MethodValidatorController {
    private Map<String, MethodValidator> methodValidatorContext = new HashMap<String, MethodValidator>();
    private List<MethodValidator> methodValidators;
    private DefaultMethodValidatorImpl defaultMethodValidator;

    @Autowired
    public MethodValidatorController(List<MethodValidator> methodValidators, DefaultMethodValidatorImpl defaultMethodValidator) {
        this.methodValidators = methodValidators;
        this.defaultMethodValidator = defaultMethodValidator;
        this.createMethodValidationContext();
    }

    public MethodValidator getMethod(String methodName) {
        return Optional.ofNullable(this.methodValidatorContext.get(methodName)).orElse(this.defaultMethodValidator);
    }

    private void createMethodValidationContext() {
        this.methodValidators.forEach(m -> this.methodValidatorContext.put(m.getMethodName(), (MethodValidator)m));
    }
}

