/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.util;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

public class LogbackPatternLayout
extends PatternLayout {
    private final Map<Pattern, String> mapForReplacement = new HashMap<Pattern, String>();
    static final String MASK = "*****";

    public LogbackPatternLayout() {
        String replaceField = "$1\"*****\"";
        String replaceHeader = "$1*****";
        UnaryOperator replace = name -> "\"" + name + "\":\"*****\"";
        UnaryOperator fieldRegex = name -> "(\"" + name + "\"\\s*:\\s*)\"[^\"]+\"";
        UnaryOperator headerRegex = name -> "(" + name + "\\s*:\\s*)[^,]+";
        UnaryOperator objectRegex = name -> "(\"" + name + "\"\\s*:\\s*\\{)[^}]+}";
        Function<String, Pattern> buildPattern = regex -> Pattern.compile(regex, 2);
        this.mapForReplacement.put(buildPattern.apply((String)fieldRegex.apply("ownerName")), replaceField);
        this.mapForReplacement.put(buildPattern.apply((String)fieldRegex.apply("\\w*[Pp]assword")), replaceField);
        this.mapForReplacement.put(buildPattern.apply((String)fieldRegex.apply("access_token")), replaceField);
        this.mapForReplacement.put(buildPattern.apply((String)fieldRegex.apply("refresh_token")), replaceField);
        this.mapForReplacement.put(buildPattern.apply((String)headerRegex.apply("Authorization")), replaceHeader);
        this.mapForReplacement.put(buildPattern.apply((String)objectRegex.apply("ownerAddress")), (String)replace.apply("ownerAddress"));
    }

    public String doLayout(ILoggingEvent event) {
        return this.modifyMessage(super.doLayout(event));
    }

    String modifyMessage(String message) {
        String logMessage = message;
        for (Map.Entry<Pattern, String> next : this.mapForReplacement.entrySet()) {
            logMessage = next.getKey().matcher(logMessage).replaceAll(next.getValue());
        }
        return logMessage;
    }
}

