/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.validator.signature.DigestVerifier;
import de.adorsys.psd2.validator.signature.SignatureVerifier;
import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignatureFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    private static final String PATTERN_MESSAGE = "TPP unauthorized: {}";
    private final AspspProfileServiceWrapper aspspProfileService;
    private final TppErrorMessageWriter tppErrorMessageWriter;
    private final DigestVerifier digestVerifier;
    private final SignatureVerifier signatureVerifier;

    public SignatureFilter(TppErrorMessageWriter tppErrorMessageWriter, Xs2aEndpointChecker xs2aEndpointChecker, AspspProfileServiceWrapper aspspProfileService, TppErrorMessageWriter tppErrorMessageWriter1, DigestVerifier digestVerifier, SignatureVerifier signatureVerifier) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.aspspProfileService = aspspProfileService;
        this.tppErrorMessageWriter = tppErrorMessageWriter1;
        this.digestVerifier = digestVerifier;
        this.signatureVerifier = signatureVerifier;
    }

    @Override
    protected void doFilterInternalCustom(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String body;
        if (!this.aspspProfileService.getTppSignatureRequired().booleanValue()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.validateHeadersExist(request, response)) {
            return;
        }
        String digest = request.getHeader("Digest");
        boolean digestValid = this.digestVerifier.verify(digest, body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        if (!digestValid) {
            String errorText = "Mandatory header 'digest' is invalid!";
            log.info(PATTERN_MESSAGE, (Object)errorText);
            this.setResponseStatusAndErrorCode(response, MessageErrorCode.FORMAT_ERROR);
            return;
        }
        Map<String, String> allHeaders = this.obtainRequestHeaders(request);
        String signature = request.getHeader("Signature");
        String method = request.getMethod();
        String url = request.getRequestURL().toString();
        String encodedCertificate = request.getHeader("TPP-Signature-Certificate");
        boolean signatureValid = this.signatureVerifier.verify(signature, encodedCertificate, allHeaders, method, url);
        if (!signatureValid) {
            String errorText = "Mandatory header 'signature' is invalid!";
            log.info(PATTERN_MESSAGE, (Object)errorText);
            this.setResponseStatusAndErrorCode(response, MessageErrorCode.SIGNATURE_INVALID);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Map<String, String> obtainRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    private boolean validateHeadersExist(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (StringUtils.isBlank((CharSequence)request.getHeader("X-Request-ID"))) {
            String errorText = "Header 'x-request-id' is missing in request.";
            log.info(PATTERN_MESSAGE, (Object)errorText);
            this.setResponseStatusAndErrorCode(response, MessageErrorCode.FORMAT_ERROR);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)request.getHeader("Signature"))) {
            String errorText = "Header 'signature' is missing in request.";
            log.info(PATTERN_MESSAGE, (Object)errorText);
            this.setResponseStatusAndErrorCode(response, MessageErrorCode.SIGNATURE_MISSING);
            return false;
        }
        StringBuilder otherErrorMessages = new StringBuilder();
        Stream.of("TPP-Signature-Certificate", "Digest", "Date").filter(nm -> StringUtils.isBlank((CharSequence)request.getHeader(nm))).forEach(nm -> this.appendMessageError(otherErrorMessages, (String)nm));
        if (otherErrorMessages.length() > 0) {
            log.info(PATTERN_MESSAGE, (Object)otherErrorMessages.toString());
            this.setResponseStatusAndErrorCode(response, MessageErrorCode.FORMAT_ERROR);
            return false;
        }
        return true;
    }

    private void appendMessageError(StringBuilder errorMessages, String headerName) {
        errorMessages.append("Header '").append(headerName).append("' is missing in request.").append("\n");
    }

    private void setResponseStatusAndErrorCode(HttpServletResponse response, MessageErrorCode messageErrorCode) throws IOException {
        this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, messageErrorCode, new Object[0]));
    }
}

