/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aConsentService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPiisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmbeddedPiisAuthorizationService
implements PiisAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPiisAuthorizationService.class);
    private final Xs2aConsentService consentService;
    private final Xs2aPiisConsentService piisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aPiisConsentMapper piisConsentMapper;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        Optional<PiisConsent> piisConsentOptional = this.piisConsentService.getPiisConsentById(consentId);
        if (piisConsentOptional.isEmpty()) {
            log.info("Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", (Object)consentId);
            return Optional.empty();
        }
        return this.consentService.createConsentAuthorisation(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            return resp;
        });
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        if (response.hasError()) {
            log.info("Consent-ID [{}], Authorisation-ID [{}]. Update consent authorisation failed. Error msg: {}.", new Object[]{request.getBusinessObjectId(), request.getAuthorisationId(), response.getErrorHolder()});
        } else {
            this.piisConsentService.updateConsentAuthorisation(this.piisConsentMapper.mapToUpdateConsentPsuDataReq(request, response));
        }
        return response;
    }

    @Override
    public Optional<Authorisation> getConsentAuthorizationById(String authorizationId) {
        return this.authorisationService.getAuthorisationById(authorizationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.consentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.EMBEDDED;
    }

    @ConstructorProperties(value={"consentService", "piisConsentService", "authorisationService", "piisConsentMapper"})
    public EmbeddedPiisAuthorizationService(Xs2aConsentService consentService, Xs2aPiisConsentService piisConsentService, Xs2aAuthorisationService authorisationService, Xs2aPiisConsentMapper piisConsentMapper) {
        this.consentService = consentService;
        this.piisConsentService = piisConsentService;
        this.authorisationService = authorisationService;
        this.piisConsentMapper = piisConsentMapper;
    }
}

