/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.query.account;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.query.AbstractQueryParameterValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.query.account.TransactionListQueryParamsValidator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DateFromQueryParameterParamsValidatorImpl
extends AbstractQueryParameterValidatorImpl
implements TransactionListQueryParamsValidator {
    private static final String DATE_FROM_PARAMETER_NAME = "dateFrom";
    private static final String ENTRY_REFERENCE_FROM_PARAMETER_NAME = "entryReferenceFrom";
    private static final String DELTA_LIST_PARAMETER_NAME = "deltaList";

    public DateFromQueryParameterParamsValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getQueryParameterName() {
        return DATE_FROM_PARAMETER_NAME;
    }

    @Override
    public MessageError validate(Map<String, List<String>> queryParameterMap, MessageError messageError) {
        String dateFrom = this.getQueryParameterValue(queryParameterMap, this.getQueryParameterName());
        if (dateFrom != null && !this.isDateParamValid(dateFrom)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, (Object[])new Object[]{this.getQueryParameterName()}));
        }
        if (dateFrom == null && !this.isDeltaAccess(queryParameterMap)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_ABSENT_PARAMETER, (Object[])new Object[]{this.getQueryParameterName()}));
        }
        return messageError;
    }

    private boolean isDeltaAccess(Map<String, List<String>> queryParameterMap) {
        String entryReferenceFrom = this.getQueryParameterValue(queryParameterMap, ENTRY_REFERENCE_FROM_PARAMETER_NAME);
        String deltaList = this.getQueryParameterValue(queryParameterMap, DELTA_LIST_PARAMETER_NAME);
        return entryReferenceFrom != null || deltaList != null;
    }
}

