/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeadersLengthValidatorImpl
extends AbstractHeaderValidatorImpl
implements ConsentHeaderValidator,
PaymentHeaderValidator {
    static final Map<String, Integer> headerMaxLengths;

    @Autowired
    public HeadersLengthValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return null;
    }

    @Override
    public MessageError validate(Map<String, String> inputHeaders, MessageError messageError) {
        for (Map.Entry<String, String> header : inputHeaders.entrySet()) {
            if (!this.isHeaderExceedsLength(header)) continue;
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_OVERSIZE_HEADER, (Object[])new Object[]{header.getKey(), headerMaxLengths.get(header.getKey())}));
        }
        return messageError;
    }

    private boolean isHeaderExceedsLength(Map.Entry<String, String> header) {
        String headerName = header.getKey();
        String headerValue = header.getValue();
        if (headerName == null || headerValue == null) {
            return false;
        }
        String headerNameLowerCase = headerName.toLowerCase();
        Set<String> headersToValidate = headerMaxLengths.keySet();
        return headersToValidate.contains(headerNameLowerCase) && headerValue.length() > headerMaxLengths.get(headerNameLowerCase);
    }

    static {
        HashMap<String, Integer> maxLengthsHolder = new HashMap<String, Integer>();
        maxLengthsHolder.put("psu-id", 50);
        maxLengthsHolder.put("psu-id-type", 50);
        maxLengthsHolder.put("psu-corporate-id", 50);
        maxLengthsHolder.put("psu-corporate-id-type", 50);
        maxLengthsHolder.put("tpp-redirect-uri", 500);
        maxLengthsHolder.put("tpp-nok-redirect-uri", 500);
        maxLengthsHolder.put("tpp-brand-logging-information", 255);
        maxLengthsHolder.put("psu-ip-address", 140);
        headerMaxLengths = Collections.unmodifiableMap(maxLengthsHolder);
    }
}

