/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class FundsConfirmationLoggingInterceptor
extends HandlerInterceptorAdapter {
    private final TppService tppService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withRequestUri().perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withResponseStatus().perform();
    }

    @ConstructorProperties(value={"tppService"})
    public FundsConfirmationLoggingInterceptor(TppService tppService) {
        this.tppService = tppService;
    }
}

