/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.FundsConfirmationApi;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.service.FundsConfirmationService;
import de.adorsys.psd2.xs2a.service.mapper.FundsConfirmationModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import java.beans.ConstructorProperties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FundsConfirmationController
implements FundsConfirmationApi {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationController.class);
    private final ResponseMapper responseMapper;
    private final ResponseErrorMapper responseErrorMapper;
    private final FundsConfirmationService fundsConfirmationService;
    private final FundsConfirmationModelMapper fundsConfirmationModelMapper;

    public ResponseEntity checkAvailabilityOfFunds(ConfirmationOfFunds body, UUID xRequestID, String consentID, String authorization, String digest, String signature, byte[] tpPSignatureCertificate) {
        ResponseObject<FundsConfirmationResponse> responseObject = this.fundsConfirmationService.fundsConfirmation(this.fundsConfirmationModelMapper.mapToFundsConfirmationRequest(body, consentID));
        return responseObject.hasError() ? this.responseErrorMapper.generateErrorResponse(responseObject.getError()) : this.responseMapper.ok(responseObject, this.fundsConfirmationModelMapper::mapToInlineResponse2003);
    }

    @ConstructorProperties(value={"responseMapper", "responseErrorMapper", "fundsConfirmationService", "fundsConfirmationModelMapper"})
    public FundsConfirmationController(ResponseMapper responseMapper, ResponseErrorMapper responseErrorMapper, FundsConfirmationService fundsConfirmationService, FundsConfirmationModelMapper fundsConfirmationModelMapper) {
        this.responseMapper = responseMapper;
        this.responseErrorMapper = responseErrorMapper;
        this.fundsConfirmationService = fundsConfirmationService;
        this.fundsConfirmationModelMapper = fundsConfirmationModelMapper;
    }
}

