/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public final class TppRoleAccess {
    private static AntPathMatcher matcher = new AntPathMatcher();
    private static Map<String, Set<TppRole>> secureURIs = new HashMap<String, Set<TppRole>>();

    static boolean hasAccessForPath(List<TppRole> tppRoles, String targetPath) {
        for (Map.Entry<String, Set<TppRole>> entry : secureURIs.entrySet()) {
            Set<TppRole> allowedRoles = entry.getValue();
            String pattern = entry.getKey();
            if (!matcher.match(pattern, targetPath)) continue;
            return tppRoles.stream().anyMatch(allowedRoles::contains);
        }
        return true;
    }

    static void linkTppRolePatterns(String pattern, TppRole ... tppRoles) {
        Assert.notEmpty((Object[])tppRoles, (String)"Tpp roles must be set!");
        Set roles = Arrays.stream(tppRoles).collect(Collectors.toSet());
        if (secureURIs.containsKey(pattern)) {
            secureURIs.get(pattern).addAll(roles);
        } else {
            secureURIs.put(pattern, roles);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TppRoleAccess;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TppRoleAccess()";
    }

    private TppRoleAccess() {
    }

    static {
        TppRoleAccess.linkTppRolePatterns("/v1/accounts/**", TppRole.AISP);
        TppRoleAccess.linkTppRolePatterns("/v1/trusted-beneficiaries", TppRole.AISP);
        TppRoleAccess.linkTppRolePatterns("/v1/card-accounts/**", TppRole.AISP);
        TppRoleAccess.linkTppRolePatterns("/v1/consents/**", TppRole.AISP);
        TppRoleAccess.linkTppRolePatterns("/v1/bulk-payments/**", TppRole.PISP);
        TppRoleAccess.linkTppRolePatterns("/v1/payments/**", TppRole.PISP);
        TppRoleAccess.linkTppRolePatterns("/v1/periodic-payments/**", TppRole.PISP);
        TppRoleAccess.linkTppRolePatterns("/v1/funds-confirmations/**", TppRole.PIISP);
    }
}

