/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetTrustedBeneficiariesListConsentObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetTrustedBeneficiariesListValidator
extends AbstractAccountTppValidator<GetTrustedBeneficiariesListConsentObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AspspProfileServiceWrapper aspspProfileService;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetTrustedBeneficiariesListConsentObject consentObject) {
        AisConsent aisConsent = consentObject.getAisConsent();
        ValidationResult accountConsentValidationResult = this.accountConsentValidator.validate(aisConsent, consentObject.getRequestUri());
        if (accountConsentValidationResult.isNotValid()) {
            return accountConsentValidationResult;
        }
        if (!this.aspspProfileService.isTrustedBeneficiariesSupported()) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_405, (MessageErrorCode)MessageErrorCode.SERVICE_INVALID_405);
        }
        if (aisConsent.isGlobalConsent()) {
            return ValidationResult.valid();
        }
        if (aisConsent.isConsentForAllAvailableAccounts()) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.CONSENT_INVALID);
        }
        if (this.doesNotDedicatedConsentHaveRights(aisConsent)) {
            return ValidationResult.invalid((ErrorType)ErrorType.AIS_401, (MessageErrorCode)MessageErrorCode.CONSENT_INVALID);
        }
        return ValidationResult.valid();
    }

    private boolean doesNotDedicatedConsentHaveRights(AisConsent aisConsent) {
        AdditionalInformationAccess additionalInformationAccess = aisConsent.getAccess().getAdditionalInformationAccess();
        boolean isConsentDedicated = aisConsent.isConsentForDedicatedAccounts();
        boolean isNotTrustedBeneficiariesSupported = additionalInformationAccess == null || additionalInformationAccess.getTrustedBeneficiaries() == null;
        return isConsentDedicated && isNotTrustedBeneficiariesSupported;
    }

    @ConstructorProperties(value={"accountConsentValidator", "aspspProfileService"})
    public GetTrustedBeneficiariesListValidator(AccountConsentValidator accountConsentValidator, AspspProfileServiceWrapper aspspProfileService) {
        this.accountConsentValidator = accountConsentValidator;
        this.aspspProfileService = aspspProfileService;
    }
}

