/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.read;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.payment.read.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadPaymentService
implements ReadPaymentService {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadPaymentService.class);
    protected SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService;
    private final SpiPaymentFactory spiPaymentFactory;

    @Override
    public PaymentInformationResponse<CommonPayment> getPayment(CommonPaymentData commonPaymentData, PsuIdData psuData, @NotNull String encryptedPaymentId, String acceptMediaType) {
        if (ArrayUtils.isEmpty((byte[])commonPaymentData.getPaymentData())) {
            return new PaymentInformationResponse<CommonPayment>(ErrorHolder.builder((ErrorType)ErrorType.PIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_FOUND)}).build());
        }
        Optional<SpiPayment> spiPaymentOptional = this.spiPaymentFactory.getSpiPayment(commonPaymentData);
        if (spiPaymentOptional.isEmpty()) {
            return new PaymentInformationResponse<CommonPayment>(ErrorHolder.builder((ErrorType)ErrorType.PIS_404).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)}).build());
        }
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.getSpiPaymentById(spiContextData, acceptMediaType, spiPaymentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("Payment-ID [{}]. Read payment failed. Can't get payment by ID at SPI level. Error msg: [{}]", (Object)spiPaymentOptional.get().getPaymentId(), (Object)errorHolder);
            return new PaymentInformationResponse<CommonPayment>(errorHolder);
        }
        CommonPayment xs2aPayment = this.getXs2aPayment(spiResponse);
        TransactionStatus paymentStatus = xs2aPayment.getTransactionStatus();
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, paymentStatus)) {
            log.info("Internal payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", (Object)xs2aPayment.getPaymentId(), (Object)paymentStatus);
        }
        return new PaymentInformationResponse<CommonPayment>(xs2aPayment);
    }

    protected abstract SpiResponse getSpiPaymentById(SpiContextData var1, String var2, Object var3, SpiAspspConsentDataProvider var4);

    protected abstract CommonPayment getXs2aPayment(SpiResponse var1);

    @ConstructorProperties(value={"spiContextDataProvider", "spiErrorMapper", "aspspConsentDataProviderFactory", "updatePaymentStatusAfterSpiService", "spiPaymentFactory"})
    public AbstractReadPaymentService(SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, SpiPaymentFactory spiPaymentFactory) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.spiPaymentFactory = spiPaymentFactory;
    }
}

