/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.pis.InternalPaymentStatus;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class Xs2aUpdatePaymentAfterSpiService {
    private final UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService;
    private final LoggingContextService loggingContextService;

    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status) {
        boolean statusUpdated;
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentStatus(paymentId, status);
        boolean bl = statusUpdated = response.isSuccessful() && (Boolean)response.getPayload() != false;
        if (statusUpdated) {
            this.loggingContextService.storeTransactionStatus(status);
        }
        return statusUpdated;
    }

    public boolean updateInternalPaymentStatus(@NotNull String paymentId, @NotNull InternalPaymentStatus status) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updateInternalPaymentStatus(paymentId, status);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean updatePaymentCancellationTppRedirectUri(@NotNull String paymentId, @NotNull TppRedirectUri tppRedirectUri) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(paymentId, tppRedirectUri);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean updatePaymentCancellationInternalRequestId(@NotNull String paymentId, @NotNull String internalRequestId) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(paymentId, internalRequestId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    @ConstructorProperties(value={"updatePaymentStatusAfterSpiService", "loggingContextService"})
    public Xs2aUpdatePaymentAfterSpiService(UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService, LoggingContextService loggingContextService) {
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.loggingContextService = loggingContextService;
    }
}

