/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationAccess;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aAccountAccessMapper {
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;

    public Optional<AccountAccess> mapToAccountAccess(SpiAccountAccess access) {
        return Optional.ofNullable(access).map(aa -> new AccountAccess(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReferences(aa.getAccounts()), this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReferences(aa.getBalances()), this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReferences(aa.getTransactions()), this.mapToAdditionalInformationAccess(aa.getSpiAdditionalInformationAccess())));
    }

    public AccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new AccountAccess(new ArrayList(), new ArrayList(), new ArrayList(), this.modifyAdditionalInformationAccessOnGlobalOrAllAvailableAccountsConsent(request.getAccess().getAdditionalInformationAccess()));
    }

    private AdditionalInformationAccess modifyAdditionalInformationAccessOnGlobalOrAllAvailableAccountsConsent(AdditionalInformationAccess info) {
        if (info == null || info.noAdditionalInformationAccess()) {
            return null;
        }
        UnaryOperator modifier = list -> list == null ? null : Collections.emptyList();
        return new AdditionalInformationAccess((List)modifier.apply(info.getOwnerName()), (List)modifier.apply(info.getTrustedBeneficiaries()));
    }

    private AdditionalInformationAccess mapToAdditionalInformationAccess(SpiAdditionalInformationAccess spiAdditionalInformationAccess) {
        return Optional.ofNullable(spiAdditionalInformationAccess).map(info -> new AdditionalInformationAccess(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReferences(info.getOwnerName()), this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReferences(info.getTrustedBeneficiaries()))).orElse(null);
    }

    @ConstructorProperties(value={"spiToXs2aAccountReferenceMapper"})
    public SpiToXs2aAccountAccessMapper(SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper) {
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
    }
}

