/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor;

import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.AisAuthorisationProcessorServiceImpl;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.AuthorisationProcessorService;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.PiisAuthorisationProcessorServiceImpl;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.PisAuthorisationProcessorServiceImpl;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.PisCancellationAuthorisationProcessorServiceImpl;
import org.springframework.context.ApplicationContext;

public abstract class AuthorisationProcessor {
    private final ApplicationContext applicationContext;
    private AuthorisationProcessor nextProcessor;

    protected AuthorisationProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setNext(AuthorisationProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public abstract ScaStatus getScaStatus();

    protected abstract AuthorisationProcessorResponse execute(AuthorisationProcessorRequest var1, AuthorisationProcessorService var2);

    public AuthorisationProcessorResponse apply(AuthorisationProcessorRequest request) {
        AuthorisationProcessorResponse processorResponse = this.process(request);
        this.getProcessorService(request).updateAuthorisation(request, processorResponse);
        return processorResponse;
    }

    AuthorisationProcessorResponse process(AuthorisationProcessorRequest request) {
        if (this.getScaStatus() == request.getScaStatus()) {
            AuthorisationProcessorService processorService = this.getProcessorService(request);
            return this.execute(request, processorService);
        }
        if (this.hasNext()) {
            return this.nextProcessor.process(request);
        }
        return null;
    }

    AuthorisationProcessorService getProcessorService(AuthorisationProcessorRequest request) {
        if (request.getServiceType() == ServiceType.AIS) {
            return (AuthorisationProcessorService)this.applicationContext.getBean(AisAuthorisationProcessorServiceImpl.class);
        }
        if (request.getServiceType() == ServiceType.PIS && request.getAuthorisation().getAuthorisationType() == AuthorisationType.PIS_CREATION) {
            return (AuthorisationProcessorService)this.applicationContext.getBean(PisAuthorisationProcessorServiceImpl.class);
        }
        if (request.getServiceType() == ServiceType.PIS && request.getAuthorisation().getAuthorisationType() == AuthorisationType.PIS_CANCELLATION) {
            return (AuthorisationProcessorService)this.applicationContext.getBean(PisCancellationAuthorisationProcessorServiceImpl.class);
        }
        if (request.getServiceType() == ServiceType.PIIS) {
            return (AuthorisationProcessorService)this.applicationContext.getBean(PiisAuthorisationProcessorServiceImpl.class);
        }
        throw new IllegalArgumentException("Authorisation processor service is unknown: " + request);
    }

    private boolean hasNext() {
        return this.nextProcessor != null;
    }
}

