/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.core.profile.StartAuthorisationMode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationMethodDecider {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMethodDecider.class);
    private final AspspProfileServiceWrapper aspspProfileService;

    public boolean isExplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        boolean explicit = false;
        StartAuthorisationMode startAuthorisationMode = this.aspspProfileService.getStartAuthorisationMode();
        explicit = StartAuthorisationMode.AUTO.equals((Object)startAuthorisationMode) ? multilevelScaRequired || this.isSigningBasketModeActive(tppExplicitAuthorisationPreferred) : StartAuthorisationMode.EXPLICIT.equals((Object)startAuthorisationMode);
        log.info("{} authorisation method chosen", (Object)(explicit ? "EXPLICIT" : "IMPLICIT"));
        return explicit;
    }

    public boolean isImplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        return !this.isExplicitMethod(tppExplicitAuthorisationPreferred, multilevelScaRequired);
    }

    public boolean isSigningBasketModeActive(boolean tppExplicitAuthorisationPreferred) {
        return tppExplicitAuthorisationPreferred && this.aspspProfileService.isSigningBasketSupported();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AuthorisationMethodDecider(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

