/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.PaymentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.PsuIdDataAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.event.EventAuthorisationType;
import de.adorsys.psd2.xs2a.service.event.EventTypeService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.validator.pis.CommonPaymentObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.CreatePisAuthorisationObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.CreatePisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataValidator;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentAuthorisationServiceImpl
implements PaymentAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentAuthorisationServiceImpl.class);
    private final Xs2aEventService xs2aEventService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final CreatePisAuthorisationValidator createPisAuthorisationValidator;
    private final UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator;
    private final GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator;
    private final GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator;
    private final PisPsuDataService pisPsuDataService;
    private final LoggingContextService loggingContextService;
    private final PsuIdDataAuthorisationService psuIdDataAuthorisationService;
    private final EventTypeService eventTypeService;

    @Override
    public ResponseObject<AuthorisationResponse> createPisAuthorisation(Xs2aCreatePisAuthorisationRequest createRequest) {
        ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorisationResponse = this.createPisAuthorisation(createRequest.getPaymentId(), createRequest.getPaymentService(), createRequest.getPaymentProduct(), createRequest.getPsuData());
        if (createPisAuthorisationResponse.hasError()) {
            return ResponseObject.builder().fail(createPisAuthorisationResponse.getError()).build();
        }
        PsuIdData psuIdDataFromResponse = createPisAuthorisationResponse.getBody().getPsuIdData();
        if (psuIdDataFromResponse == null || psuIdDataFromResponse.isEmpty() || StringUtils.isBlank((CharSequence)createRequest.getPassword())) {
            return ResponseObject.builder().body(createPisAuthorisationResponse.getBody()).build();
        }
        String authorisationId = createPisAuthorisationResponse.getBody().getAuthorisationId();
        Xs2aUpdatePisCommonPaymentPsuDataRequest updateRequest = new Xs2aUpdatePisCommonPaymentPsuDataRequest(createRequest, authorisationId);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePsuDataResponse = this.updatePisCommonPaymentPsuData(updateRequest);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    @Override
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCommonPaymentPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), this.eventTypeService.getEventType(request, EventAuthorisationType.PIS), request);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(request.getPaymentId());
        if (pisCommonPaymentResponse.isEmpty()) {
            log.info("Payment-ID [{}]. Update PIS CommonPayment PSU data failed. PIS CommonPayment not found by id", (Object)request.getPaymentId());
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPayment = pisCommonPaymentResponse.get();
        this.loggingContextService.storeTransactionStatus(pisCommonPayment.getTransactionStatus());
        ValidationResult validationResult = this.updatePisCommonPaymentPsuDataValidator.validate(new UpdatePisCommonPaymentPsuDataPO(pisCommonPayment, request));
        if (validationResult.isNotValid()) {
            MessageErrorCode messageErrorCode = validationResult.getMessageError().getTppMessage().getMessageErrorCode();
            if (EnumSet.of(MessageErrorCode.PSU_CREDENTIALS_INVALID, MessageErrorCode.FORMAT_ERROR_NO_PSU).contains(messageErrorCode)) {
                this.authorisationService.updateAuthorisationStatus(request.getAuthorisationId(), ScaStatus.FAILED);
            }
            log.info("Payment-ID [{}]. Update PIS CommonPayment PSU data - validation failed: {}", (Object)request.getPaymentId(), (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService(request.getAuthorisationId());
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = pisScaAuthorisationService.updateCommonPaymentPsuData(request);
        this.loggingContextService.storeScaStatus(response.getScaStatus());
        return response.hasError() ? ResponseObject.builder().fail(response.getErrorHolder()).build() : ResponseObject.builder().body(response).build();
    }

    @Override
    public ResponseObject<Xs2aAuthorisationSubResources> getPaymentInitiationAuthorisations(String paymentId, String paymentProduct, PaymentType paymentType) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (pisCommonPaymentResponseOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Get Payment authorisation failed. PIS CommonPayment not found by id", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentResponseOptional.get();
        ValidationResult validationResult = this.getPaymentAuthorisationsValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get payment initiation authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        this.loggingContextService.storeTransactionStatus(pisCommonPaymentResponse.getTransactionStatus());
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        return pisScaAuthorisationService.getAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(() -> {
            log.info("Payment-ID [{}]. Get payment initiation authorisation has failed. Authorisation not found by payment id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    @Override
    public ResponseObject<PaymentScaStatus> getPaymentInitiationAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (pisCommonPaymentResponseOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Get SCA status payment initiation authorisation failed. PIS CommonPayment not found by id", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentResponseOptional.get();
        ValidationResult validationResult = this.getPaymentAuthorisationScaStatusValidator.validate(new GetPaymentInitiationAuthorisationScaStatusPO(pisCommonPaymentResponse, authorisationId, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get SCA status payment initiation authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService(authorisationId);
        Optional<ScaStatus> scaStatusOptional = pisScaAuthorisationService.getAuthorisationScaStatus(paymentId, authorisationId);
        if (scaStatusOptional.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        ScaStatus scaStatus = scaStatusOptional.get();
        PsuIdData psuIdData = this.psuIdDataAuthorisationService.getPsuIdData(authorisationId, pisCommonPaymentResponse.getPsuData());
        PaymentScaStatus paymentScaStatus = new PaymentScaStatus(psuIdData, pisCommonPaymentResponse, scaStatus);
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPaymentResponse.getTransactionStatus(), scaStatus);
        return ResponseObject.builder().body(paymentScaStatus).build();
    }

    private ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorisation(String paymentId, PaymentType paymentService, String paymentProduct, PsuIdData psuDataFromRequest) {
        PsuIdData psuIdData;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (pisCommonPaymentResponseOptional.isEmpty()) {
            log.info("Payment-ID [{}]. Create PIS Authorisation failed. PIS CommonPayment not found by id", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPayment = pisCommonPaymentResponseOptional.get();
        ValidationResult validationResult = this.createPisAuthorisationValidator.validate(new CreatePisAuthorisationObject(pisCommonPayment, paymentService, paymentProduct, psuDataFromRequest));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Create PIS Authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        Optional<Xs2aCreatePisAuthorisationResponse> commonPaymentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(paymentId, paymentService, psuIdData = this.getActualPsuData(psuDataFromRequest, paymentId, pisCommonPayment.isMultilevelScaRequired()));
        if (commonPaymentAuthorisation.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PAYMENT_FAILED)).build();
        }
        Xs2aCreatePisAuthorisationResponse createAuthorisationResponse = commonPaymentAuthorisation.get();
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPayment.getTransactionStatus(), createAuthorisationResponse.getScaStatus());
        return ResponseObject.builder().body(createAuthorisationResponse).build();
    }

    private PsuIdData getActualPsuData(PsuIdData psuDataFromRequest, String paymentId, boolean isMultilevel) {
        if (psuDataFromRequest.isNotEmpty() || isMultilevel) {
            return psuDataFromRequest;
        }
        return this.pisPsuDataService.getPsuDataByPaymentId(paymentId).stream().findFirst().orElse(psuDataFromRequest);
    }

    @ConstructorProperties(value={"xs2aEventService", "pisScaAuthorisationServiceResolver", "authorisationService", "pisCommonPaymentService", "createPisAuthorisationValidator", "updatePisCommonPaymentPsuDataValidator", "getPaymentAuthorisationsValidator", "getPaymentAuthorisationScaStatusValidator", "pisPsuDataService", "loggingContextService", "psuIdDataAuthorisationService", "eventTypeService"})
    public PaymentAuthorisationServiceImpl(Xs2aEventService xs2aEventService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, Xs2aAuthorisationService authorisationService, Xs2aPisCommonPaymentService pisCommonPaymentService, CreatePisAuthorisationValidator createPisAuthorisationValidator, UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator, GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator, GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator, PisPsuDataService pisPsuDataService, LoggingContextService loggingContextService, PsuIdDataAuthorisationService psuIdDataAuthorisationService, EventTypeService eventTypeService) {
        this.xs2aEventService = xs2aEventService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.authorisationService = authorisationService;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.createPisAuthorisationValidator = createPisAuthorisationValidator;
        this.updatePisCommonPaymentPsuDataValidator = updatePisCommonPaymentPsuDataValidator;
        this.getPaymentAuthorisationsValidator = getPaymentAuthorisationsValidator;
        this.getPaymentAuthorisationScaStatusValidator = getPaymentAuthorisationScaStatusValidator;
        this.pisPsuDataService = pisPsuDataService;
        this.loggingContextService = loggingContextService;
        this.psuIdDataAuthorisationService = psuIdDataAuthorisationService;
        this.eventTypeService = eventTypeService;
    }
}

