/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.OauthValidator;
import org.springframework.stereotype.Component;

@Component
public class OauthPiisConsentValidator
extends OauthValidator<PiisConsent> {
    private static final MessageError MESSAGE_ERROR = new MessageError(ErrorType.PIIS_403, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORBIDDEN)});

    public OauthPiisConsentValidator(RequestProviderService requestProviderService, AspspProfileServiceWrapper aspspProfileServiceWrapper, ScaApproachResolver scaApproachResolver) {
        super(requestProviderService, aspspProfileServiceWrapper, scaApproachResolver);
    }

    @Override
    protected boolean checkObjectForTokenAbsence(PiisConsent piisConsent) {
        return piisConsent.getConsentStatus() == ConsentStatus.VALID;
    }

    @Override
    protected MessageError getMessageError() {
        return MESSAGE_ERROR;
    }
}

