/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.piis.PiisConsentData;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAccountConsentAuthorizationMapper;
import java.util.Collections;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={ConsentDataMapper.class, Xs2aAccountConsentAuthorizationMapper.class})
public abstract class Xs2aPiisConsentMapper {
    private static final Integer PIIS_FREQUENCY_PER_DAY = 0;
    @Autowired
    protected ConsentDataMapper consentDataMapper;
    @Autowired
    protected RequestProviderService requestProviderService;

    @Mapping(target="consentTppInformation", source="tppInformation")
    public abstract PiisConsent mapToPiisConsent(CmsConsent var1);

    public UpdateConsentPsuDataReq mapToUpdateConsentPsuDataReq(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        return Optional.ofNullable(response).map(data -> {
            UpdateConsentPsuDataReq req = new UpdateConsentPsuDataReq();
            req.setPsuData(response.getPsuData());
            req.setConsentId(request.getBusinessObjectId());
            req.setAuthorizationId(request.getAuthorisationId());
            req.setAuthenticationMethodId(Optional.ofNullable(data.getChosenScaMethod()).map(AuthenticationObject::getAuthenticationMethodId).orElse(null));
            req.setScaAuthenticationData(request.getScaAuthenticationData());
            req.setScaStatus(data.getScaStatus());
            req.setAuthorisationType(AuthorisationType.CONSENT);
            return req;
        }).orElse(null);
    }

    public CmsConsent mapToCmsConsent(CreatePiisConsentRequest request, PsuIdData psuData, TppInfo tppInfo) {
        PiisConsentData piisConsentData = new PiisConsentData(request.getCardNumber(), request.getCardExpiryDate(), request.getCardInformation(), request.getRegistrationInformation());
        byte[] consentDataInBytes = this.consentDataMapper.getBytesFromConsentData((Object)piisConsentData);
        CmsConsent cmsConsent = new CmsConsent();
        cmsConsent.setConsentData(consentDataInBytes);
        ConsentTppInformation tppInformation = new ConsentTppInformation();
        tppInformation.setTppInfo(tppInfo);
        tppInformation.setTppRedirectPreferred(this.requestProviderService.resolveTppRedirectPreferred().orElse(false).booleanValue());
        cmsConsent.setTppInformation(tppInformation);
        AuthorisationTemplate authorisationTemplate = new AuthorisationTemplate();
        String tppRedirectURI = this.requestProviderService.getTppRedirectURI();
        if (tppRedirectURI != null) {
            TppRedirectUri tppRedirectUri = new TppRedirectUri(tppRedirectURI, this.requestProviderService.getTppNokRedirectURI());
            authorisationTemplate.setTppRedirectUri(tppRedirectUri);
        }
        cmsConsent.setAuthorisationTemplate(authorisationTemplate);
        cmsConsent.setFrequencyPerDay(PIIS_FREQUENCY_PER_DAY);
        cmsConsent.setInternalRequestId(this.requestProviderService.getInternalRequestIdString());
        cmsConsent.setPsuIdDataList(Collections.singletonList(psuData));
        cmsConsent.setConsentType(ConsentType.PIIS_TPP);
        AccountAccess accountAccess = new AccountAccess(Collections.singletonList(request.getAccount()), Collections.emptyList(), Collections.emptyList(), null);
        cmsConsent.setTppAccountAccesses(accountAccess);
        cmsConsent.setAspspAccountAccesses(AccountAccess.EMPTY_ACCESS);
        cmsConsent.setConsentStatus(ConsentStatus.RECEIVED);
        cmsConsent.setInstanceId(this.requestProviderService.getInstanceId());
        return cmsConsent;
    }
}

