/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.profile.PiisConsentSupported;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.FundsConfirmationHeaderValidator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsentIdHeaderCofValidatorImpl
extends AbstractHeaderValidatorImpl
implements FundsConfirmationHeaderValidator {
    private final AspspProfileServiceWrapper profileService;

    @Autowired
    ConsentIdHeaderCofValidatorImpl(ErrorBuildingService errorBuildingService, AspspProfileServiceWrapper profileService) {
        super(errorBuildingService);
        this.profileService = profileService;
    }

    @Override
    protected String getHeaderName() {
        return "consent-id";
    }

    @Override
    protected ValidationResult validate(Map<String, String> headers) {
        PiisConsentSupported piisConsentSupported = this.profileService.getPiisConsentSupported();
        if (piisConsentSupported == PiisConsentSupported.TPP_CONSENT_SUPPORTED) {
            return this.checkIfHeaderIsPresented(headers);
        }
        return ValidationResult.valid();
    }
}

