package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.TrustedBeneficiary;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-19T08:36:20+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.8 (Azul Systems, Inc.)"
)
@Component
public class TrustedBeneficiariesModelMapperImpl extends TrustedBeneficiariesModelMapper {

    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public TrustedBeneficiary mapToTrustedBeneficiaries(Xs2aTrustedBeneficiaries trustedBeneficiaries) {
        if ( trustedBeneficiaries == null ) {
            return null;
        }

        TrustedBeneficiary trustedBeneficiary = new TrustedBeneficiary();

        trustedBeneficiary.setTrustedBeneficiaryId( trustedBeneficiaries.getTrustedBeneficiaryId() );
        trustedBeneficiary.setDebtorAccount( accountReferenceToAccountReference( trustedBeneficiaries.getDebtorAccount() ) );
        trustedBeneficiary.setCreditorAccount( accountReferenceToAccountReference( trustedBeneficiaries.getCreditorAccount() ) );
        trustedBeneficiary.setCreditorAgent( trustedBeneficiaries.getCreditorAgent() );
        trustedBeneficiary.setCreditorName( trustedBeneficiaries.getCreditorName() );
        trustedBeneficiary.setCreditorAlias( trustedBeneficiaries.getCreditorAlias() );
        trustedBeneficiary.setCreditorId( trustedBeneficiaries.getCreditorId() );
        trustedBeneficiary.setCreditorAddress( xs2aAddressMapper.mapToAddress( trustedBeneficiaries.getCreditorAddress() ) );

        return trustedBeneficiary;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReference accountReference1 = new AccountReference();

        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );
        if ( accountReference.getCurrency() != null ) {
            accountReference1.setCurrency( accountReference.getCurrency().getCurrencyCode() );
        }

        return accountReference1;
    }
}
