/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class CreatePisAuthorisationLinks
extends AbstractLinks {
    public CreatePisAuthorisationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, Xs2aCreatePisAuthorisationRequest createRequest, String authorisationId, ScaRedirectFlow scaRedirectFlow, String internalRequestId, boolean authorisationConfirmationRequestMandated, String instanceId) {
        super(httpUrl);
        String paymentId = createRequest.getPaymentId();
        String paymentService = createRequest.getPaymentService().getValue();
        String paymentProduct = createRequest.getPaymentProduct();
        this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        ScaApproach initiationScaApproach = scaApproachResolver.getScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(initiationScaApproach)) {
            String path = "/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}";
            this.setUpdatePsuAuthentication(this.buildPath(path, paymentService, paymentProduct, paymentId, authorisationId));
        } else if (initiationScaApproach == ScaApproach.REDIRECT) {
            String redirectId = redirectIdService.generateRedirectId(authorisationId);
            String paymentOauthLink = scaRedirectFlow == ScaRedirectFlow.OAUTH ? redirectLinkBuilder.buildPaymentScaOauthRedirectLink(paymentId, redirectId, internalRequestId) : redirectLinkBuilder.buildPaymentScaRedirectLink(paymentId, redirectId, internalRequestId, instanceId);
            this.setScaRedirectOAuthLink(scaRedirectFlow, paymentOauthLink);
            if (authorisationConfirmationRequestMandated) {
                this.setConfirmation(this.buildPath(redirectLinkBuilder.buildPisConfirmationLink(paymentService, paymentProduct, paymentId, redirectId), new Object[0]));
            }
        }
    }
}

