/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class CreateAisAuthorisationLinks
extends AbstractLinks {
    public CreateAisAuthorisationLinks(String httpUrl, CreateConsentAuthorizationResponse response, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, ScaRedirectFlow scaRedirectFlow, boolean authorisationConfirmationRequestMandated, String instanceId) {
        super(httpUrl);
        String consentId = response.getConsentId();
        String authorisationId = response.getAuthorisationId();
        this.setScaStatus(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        if (scaApproachResolver.getScaApproach(authorisationId) == ScaApproach.REDIRECT) {
            String redirectId = redirectIdService.generateRedirectId(authorisationId);
            String consentOauthLink = scaRedirectFlow == ScaRedirectFlow.OAUTH ? redirectLinkBuilder.buildConsentScaOauthRedirectLink(consentId, redirectId, response.getInternalRequestId()) : redirectLinkBuilder.buildConsentScaRedirectLink(consentId, redirectId, response.getInternalRequestId(), instanceId, ConsentType.AIS);
            this.setScaRedirectOAuthLink(scaRedirectFlow, consentOauthLink);
            if (authorisationConfirmationRequestMandated) {
                this.setConfirmation(this.buildPath(redirectLinkBuilder.buildConfirmationLink(consentId, redirectId, ConsentType.AIS), new Object[0]));
            }
        } else {
            this.setUpdatePsuAuthentication(this.buildPath("/v1/consents/{consentId}/authorisations/{authorisation-id}", consentId, authorisationId));
        }
    }
}

