/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class AccountDetailsLinks
extends AbstractLinks {
    public AccountDetailsLinks(String httpUrl, String accountId, AisConsent aisConsent) {
        super(httpUrl);
        List transactions;
        AisConsentData consentData = (AisConsentData)aisConsent.getConsentData();
        AccountAccess accountAccess = aisConsent.getAccess();
        boolean isConsentGlobal = consentData.getAllPsd2() != null;
        List balances = accountAccess.getBalances();
        if (this.hasAccessToSource(balances) && this.isValidAccountByAccess(accountId, balances, isConsentGlobal)) {
            this.setBalances(this.buildPath("/v1/accounts/{accountId}/balances", accountId));
        }
        if (this.hasAccessToSource(transactions = accountAccess.getTransactions()) && this.isValidAccountByAccess(accountId, transactions, isConsentGlobal)) {
            this.setTransactions(this.buildPath("/v1/accounts/{accountId}/transactions", accountId));
        }
    }

    private boolean isValidAccountByAccess(String accountId, List<AccountReference> allowedAccountData, boolean isConsentGlobal) {
        return isConsentGlobal || CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> accountId.equals(a.getResourceId()));
    }

    private boolean hasAccessToSource(List<AccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return true;
        }
        return !references.stream().allMatch(AccountReference::isNotIbanAccount);
    }
}

