/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.service.validator.OauthPiisConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.piis.AbstractConfirmationOfFundsConsentTppValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.ConfirmationOfFundsAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.GetConfirmationOfFundsConsentAuthorisationScaStatusPO;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetConfirmationOfFundsConsentAuthorisationScaStatusValidator
extends AbstractConfirmationOfFundsConsentTppValidator<GetConfirmationOfFundsConsentAuthorisationScaStatusPO> {
    private final ConfirmationOfFundsAuthorisationValidator confirmationOfFundsAuthorisationValidator;
    private final OauthPiisConsentValidator oauthPiisConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetConfirmationOfFundsConsentAuthorisationScaStatusPO consentObject) {
        PiisConsent piisConsent = consentObject.getPiisConsent();
        String authorisationId = consentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.confirmationOfFundsAuthorisationValidator.validate(authorisationId, piisConsent);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        ValidationResult authAuthorisationValidationResult = this.oauthPiisConsentValidator.validate(piisConsent);
        if (authAuthorisationValidationResult.isNotValid()) {
            return authAuthorisationValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"confirmationOfFundsAuthorisationValidator", "oauthPiisConsentValidator"})
    public GetConfirmationOfFundsConsentAuthorisationScaStatusValidator(ConfirmationOfFundsAuthorisationValidator confirmationOfFundsAuthorisationValidator, OauthPiisConsentValidator oauthPiisConsentValidator) {
        this.confirmationOfFundsAuthorisationValidator = confirmationOfFundsAuthorisationValidator;
        this.oauthPiisConsentValidator = oauthPiisConsentValidator;
    }
}

