/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountDetailsRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetCardAccountDetailsValidator
extends AbstractAccountTppValidator<GetCardAccountDetailsRequestObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetCardAccountDetailsRequestObject requestObject) {
        AisConsent aisConsent = requestObject.getAisConsent();
        if (aisConsent.isConsentWithNotCardAccount() && !aisConsent.isConsentForAllAvailableAccounts() && !aisConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(aisConsent, requestObject.getAccounts(), requestObject.getAccountId(), aisConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(aisConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return this.accountConsentValidator.validate(aisConsent, requestObject.getRequestUri());
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountReferenceAccessValidator", "oauthConsentValidator"})
    public GetCardAccountDetailsValidator(AccountConsentValidator accountConsentValidator, AccountReferenceAccessValidator accountReferenceAccessValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

