/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={Xs2aToSpiPsuDataMapper.class})
public abstract class Xs2aToSpiPiisConsentMapper {
    @Mappings(value={@Mapping(target="account", expression="java(toSpiAccountReference(piisConsent.getAccountReference()))"), @Mapping(target="cardExpiryDate", source="consentData.cardExpiryDate"), @Mapping(target="cardInformation", source="consentData.cardInformation"), @Mapping(target="cardNumber", source="consentData.cardNumber"), @Mapping(target="psuData", source="psuIdDataList"), @Mapping(target="registrationInformation", source="consentData.registrationInformation"), @Mapping(target="requestDateTime", source="creationTimestamp"), @Mapping(target="tppAuthorisationNumber", source="consentTppInformation.tppInfo.authorisationNumber")})
    public abstract SpiPiisConsent mapToSpiPiisConsent(PiisConsent var1);

    public SpiScaConfirmation toSpiScaConfirmation(UpdateAuthorisationRequest request, PsuIdData psuData) {
        SpiScaConfirmation accountConfirmation = new SpiScaConfirmation();
        accountConfirmation.setConsentId(request.getBusinessObjectId());
        accountConfirmation.setPsuId((String)Optional.ofNullable(psuData).map(PsuIdData::getPsuId).orElse(null));
        accountConfirmation.setTanNumber(request.getScaAuthenticationData());
        return accountConfirmation;
    }

    SpiAccountReference toSpiAccountReference(AccountReference account) {
        return new SpiAccountReference(account.getAspspAccountId(), account.getResourceId(), account.getIban(), account.getBban(), account.getPan(), account.getMaskedPan(), account.getMsisdn(), account.getCurrency());
    }
}

