/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisCheckAuthorisationConfirmationService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCurrencyConversionInfoMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCurrencyConversionInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CurrencyConversionInfoSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PisAuthorisationConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationConfirmationService.class);
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final Xs2aPisCommonPaymentMapper pisCommonPaymentMapper;
    private final Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper;
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final PisCheckAuthorisationConfirmationService pisCheckAuthorisationConfirmationService;
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final Xs2aUpdatePaymentAfterSpiService xs2aUpdatePaymentAfterSpiService;
    private final CurrencyConversionInfoSpi currencyConversionInfoSpi;
    private final SpiToXs2aCurrencyConversionInfoMapper spiToXs2aCurrencyConversionInfoMapper;

    public Xs2aUpdatePisCommonPaymentPsuDataResponse processAuthorisationConfirmation(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        String paymentId = request.getPaymentId();
        String authorisationId = request.getAuthorisationId();
        CmsResponse pisAuthorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        if (pisAuthorisationResponse.hasError()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_404).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_AUTHORISATION)}).build();
            log.info("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed: authorisation is not found by id.", (Object)paymentId, (Object)authorisationId);
            return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, request.getPsuData());
        }
        Authorisation authorisationResponse = (Authorisation)pisAuthorisationResponse.getPayload();
        ScaStatus status = authorisationResponse.getScaStatus();
        boolean processIsAllowed = status == ScaStatus.UNCONFIRMED;
        return processIsAllowed ? this.processAuthorisationConfirmationInternal(request, authorisationResponse) : this.buildScaConfirmationCodeErrorResponse(paymentId, authorisationId, request.getPsuData());
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse processAuthorisationConfirmationInternal(Xs2aUpdatePisCommonPaymentPsuDataRequest request, Authorisation authorisationResponse) {
        return this.aspspProfileServiceWrapper.isAuthorisationConfirmationCheckByXs2a() ? this.checkAuthorisationConfirmationXs2a(request, authorisationResponse) : this.checkAuthorisationConfirmationOnSpi(request, authorisationResponse);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse checkAuthorisationConfirmationXs2a(Xs2aUpdatePisCommonPaymentPsuDataRequest request, Authorisation authorisation) {
        boolean codeCorrect = StringUtils.equals((CharSequence)request.getConfirmationCode(), (CharSequence)authorisation.getScaAuthenticationData());
        CmsResponse pisCommonPaymentResponseCmsResponse = this.pisCommonPaymentServiceEncrypted.getCommonPaymentById(request.getPaymentId());
        SpiPayment payment = this.xs2aToSpiPaymentMapper.mapToSpiPayment((PisCommonPaymentResponse)pisCommonPaymentResponseCmsResponse.getPayload());
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(request.getPsuData());
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getPaymentId());
        AuthorisationType authorisationType = authorisation.getAuthorisationType();
        boolean isCancellation = AuthorisationType.PIS_CANCELLATION == authorisationType;
        SpiResponse<SpiPaymentConfirmationCodeValidationResponse> spiResponse = this.pisCheckAuthorisationConfirmationService.notifyConfirmationCodeValidation(contextData, codeCorrect, payment, isCancellation, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            return this.buildConfirmationCodeSpiErrorResponse(spiResponse, request.getPaymentId(), request.getAuthorisationId(), request.getPsuData());
        }
        SpiResponse conversionSpiResponse = this.currencyConversionInfoSpi.getCurrencyConversionInfo(contextData, payment, authorisation.getAuthorisationId(), aspspConsentDataProvider);
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = this.resolveResponse(request, codeCorrect, (SpiPaymentConfirmationCodeValidationResponse)spiResponse.getPayload(), (SpiCurrencyConversionInfo)conversionSpiResponse.getPayload());
        UpdateAuthorisationRequest updatePaymentRequest = this.pisCommonPaymentMapper.mapToUpdateAuthorisationRequest(response, authorisationType);
        if (spiResponse.isSuccessful()) {
            SpiPaymentConfirmationCodeValidationResponse payload = (SpiPaymentConfirmationCodeValidationResponse)spiResponse.getPayload();
            this.authorisationServiceEncrypted.updateAuthorisation(request.getAuthorisationId(), updatePaymentRequest);
            this.xs2aUpdatePaymentAfterSpiService.updatePaymentStatus(request.getPaymentId(), payload.getTransactionStatus());
        }
        return response;
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse resolveResponse(Xs2aUpdatePisCommonPaymentPsuDataRequest request, boolean codeCorrect, SpiPaymentConfirmationCodeValidationResponse spiResponse, SpiCurrencyConversionInfo conversionSpiResponse) {
        return codeCorrect ? this.buildResponseWithCurrencyConversionInfo(request, spiResponse, conversionSpiResponse) : this.buildScaConfirmationCodeErrorResponse(request.getPaymentId(), request.getAuthorisationId(), request.getPsuData());
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse buildResponseWithCurrencyConversionInfo(Xs2aUpdatePisCommonPaymentPsuDataRequest request, SpiPaymentConfirmationCodeValidationResponse spiConfirmationResponse, SpiCurrencyConversionInfo conversionSpiResponse) {
        return Xs2aUpdatePisCommonPaymentPsuDataResponse.buildWithCurrencyConversionInfo(spiConfirmationResponse.getScaStatus(), request.getPaymentId(), request.getAuthorisationId(), request.getPsuData(), this.spiToXs2aCurrencyConversionInfoMapper.toXs2aCurrencyConversionInfo(conversionSpiResponse));
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse checkAuthorisationConfirmationOnSpi(Xs2aUpdatePisCommonPaymentPsuDataRequest request, Authorisation authorisationResponse) {
        Xs2aUpdatePisCommonPaymentPsuDataResponse xs2aUpdatePisCommonPaymentPsuDataResponse;
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(request.getPsuData());
        CmsResponse pisCommonPaymentResponseCmsResponse = this.pisCommonPaymentServiceEncrypted.getCommonPaymentById(request.getPaymentId());
        SpiPayment payment = this.xs2aToSpiPaymentMapper.mapToSpiPayment((PisCommonPaymentResponse)pisCommonPaymentResponseCmsResponse.getPayload());
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getPaymentId());
        SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest = new SpiCheckConfirmationCodeRequest(request.getConfirmationCode(), authorisationResponse.getAuthorisationId());
        SpiResponse<SpiPaymentConfirmationCodeValidationResponse> spiResponse = this.pisCheckAuthorisationConfirmationService.checkConfirmationCode(contextData, spiCheckConfirmationCodeRequest, payment, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            this.xs2aUpdatePaymentAfterSpiService.updatePaymentStatus(request.getPaymentId(), TransactionStatus.RJCT);
            xs2aUpdatePisCommonPaymentPsuDataResponse = this.buildConfirmationCodeSpiErrorResponse(spiResponse, request.getPaymentId(), request.getAuthorisationId(), request.getPsuData());
        } else {
            SpiPaymentConfirmationCodeValidationResponse codeValidationResponse = (SpiPaymentConfirmationCodeValidationResponse)spiResponse.getPayload();
            this.xs2aUpdatePaymentAfterSpiService.updatePaymentStatus(request.getPaymentId(), codeValidationResponse.getTransactionStatus());
            SpiResponse conversionInfoSpiResponse = this.currencyConversionInfoSpi.getCurrencyConversionInfo(contextData, payment, authorisationResponse.getAuthorisationId(), aspspConsentDataProvider);
            SpiCurrencyConversionInfo spiCurrencyConversionInfo = (SpiCurrencyConversionInfo)conversionInfoSpiResponse.getPayload();
            xs2aUpdatePisCommonPaymentPsuDataResponse = Xs2aUpdatePisCommonPaymentPsuDataResponse.buildWithCurrencyConversionInfo(codeValidationResponse.getScaStatus(), request.getPaymentId(), request.getAuthorisationId(), request.getPsuData(), this.spiToXs2aCurrencyConversionInfoMapper.toXs2aCurrencyConversionInfo(spiCurrencyConversionInfo));
        }
        UpdateAuthorisationRequest updatePaymentRequest = this.pisCommonPaymentMapper.mapToUpdateAuthorisationRequest(xs2aUpdatePisCommonPaymentPsuDataResponse, authorisationResponse.getAuthorisationType());
        this.authorisationServiceEncrypted.updateAuthorisation(request.getAuthorisationId(), updatePaymentRequest);
        return xs2aUpdatePisCommonPaymentPsuDataResponse;
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse buildConfirmationCodeSpiErrorResponse(SpiResponse<SpiPaymentConfirmationCodeValidationResponse> spiResponse, String paymentId, String authorisationId, PsuIdData psuData) {
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
        log.info("Authorisation-ID: [{}]. Update payment PSU data failed: error occurred at SPI.", (Object)authorisationId);
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
    }

    private Xs2aUpdatePisCommonPaymentPsuDataResponse buildScaConfirmationCodeErrorResponse(String paymentId, String authorisationId, PsuIdData psuData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.PIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SCA_INVALID)}).build();
        log.info("Payment-ID [{}], Authorisation-ID [{}]. Updating PIS authorisation PSU Data has failed: confirmation code is wrong or has been provided more than once.", (Object)paymentId, (Object)authorisationId);
        return new Xs2aUpdatePisCommonPaymentPsuDataResponse(errorHolder, paymentId, authorisationId, psuData);
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper", "pisCommonPaymentMapper", "xs2aToSpiPaymentMapper", "authorisationServiceEncrypted", "spiContextDataProvider", "aspspConsentDataProviderFactory", "spiErrorMapper", "pisCheckAuthorisationConfirmationService", "pisCommonPaymentServiceEncrypted", "xs2aUpdatePaymentAfterSpiService", "currencyConversionInfoSpi", "spiToXs2aCurrencyConversionInfoMapper"})
    public PisAuthorisationConfirmationService(AspspProfileServiceWrapper aspspProfileServiceWrapper, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper, Xs2aToSpiPaymentMapper xs2aToSpiPaymentMapper, AuthorisationServiceEncrypted authorisationServiceEncrypted, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, PisCheckAuthorisationConfirmationService pisCheckAuthorisationConfirmationService, PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, Xs2aUpdatePaymentAfterSpiService xs2aUpdatePaymentAfterSpiService, CurrencyConversionInfoSpi currencyConversionInfoSpi, SpiToXs2aCurrencyConversionInfoMapper spiToXs2aCurrencyConversionInfoMapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.xs2aToSpiPaymentMapper = xs2aToSpiPaymentMapper;
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.pisCheckAuthorisationConfirmationService = pisCheckAuthorisationConfirmationService;
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.xs2aUpdatePaymentAfterSpiService = xs2aUpdatePaymentAfterSpiService;
        this.currencyConversionInfoSpi = currencyConversionInfoSpi;
        this.spiToXs2aCurrencyConversionInfoMapper = spiToXs2aCurrencyConversionInfoMapper;
    }
}

