/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.exception.CertificateException;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TppService {
    private static final Logger log = LoggerFactory.getLogger(TppService.class);
    private final TppInfoHolder tppInfoHolder;

    public String getTppId() {
        return Optional.ofNullable(this.tppInfoHolder.getTppInfo()).map(TppInfo::getAuthorisationNumber).orElseThrow(() -> {
            log.info("Can't get TPP id. Please check TPP Certificate");
            return new CertificateException();
        });
    }

    public TppInfo getTppInfo() {
        return Optional.ofNullable(this.tppInfoHolder.getTppInfo()).orElseThrow(() -> {
            log.info("Can't get TppInfo. Please check TPP Certificate");
            return new CertificateException();
        });
    }

    @ConstructorProperties(value={"tppInfoHolder"})
    public TppService(TppInfoHolder tppInfoHolder) {
        this.tppInfoHolder = tppInfoHolder;
    }
}

