/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreatePiisConsentResponse;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.ConfirmationOfFundsConsentScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aScaStatusResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.ConfirmationOfFundsConsentValidationService;
import de.adorsys.psd2.xs2a.service.ConsentAuthorisationService;
import de.adorsys.psd2.xs2a.service.PiisConsentAuthorisationService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.piis.PiisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPiisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPiisConsentMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.piis.CreatePiisConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.piis.dto.CreatePiisConsentRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiatePiisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PiisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentService.class);
    private final Xs2aPiisConsentService xs2aPiisConsentService;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final RequestProviderService requestProviderService;
    private final PiisConsentSpi piisConsentSpi;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aToSpiPiisConsentMapper xs2aToSpiPiisConsentMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    private final CreatePiisConsentValidator createPiisConsentValidator;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver;
    private final ConsentAuthorisationService consentAuthorisationService;
    private final ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService;
    private final PiisConsentAuthorisationService piisConsentAuthorisationService;

    public ResponseObject<Xs2aConfirmationOfFundsResponse> createPiisConsentWithResponse(CreatePiisConsentRequest request, PsuIdData psuData, boolean explicitPreferred) {
        this.xs2aEventService.recordTppRequest(EventType.CREATE_PIIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createPiisConsentValidator.validate(new CreatePiisConsentRequestObject(request, psuData));
        if (validationResult.isNotValid()) {
            log.info("Create funds confirmation consent with response - validation failed: {}", (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        Optional<Xs2aCreatePiisConsentResponse> xs2aCreatePiisConsentResponseOptional = this.xs2aPiisConsentService.createConsent(request, psuData, tppInfo);
        if (xs2aCreatePiisConsentResponseOptional.isEmpty()) {
            return ResponseObject.builder().fail(ErrorType.PIIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
        }
        Xs2aCreatePiisConsentResponse xs2aCreatePiisConsentResponse = xs2aCreatePiisConsentResponseOptional.get();
        PiisConsent piisConsent = xs2aCreatePiisConsentResponse.getPiisConsent();
        String encryptedConsentId = xs2aCreatePiisConsentResponse.getConsentId();
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiInitiatePiisConsentResponseSpiResponse = this.piisConsentSpi.initiatePiisConsent(contextData, spiPiisConsent, (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        aspspConsentDataProvider.saveWith(encryptedConsentId);
        if (spiInitiatePiisConsentResponseSpiResponse.hasError()) {
            this.xs2aPiisConsentService.updateConsentStatus(encryptedConsentId, ConsentStatus.REJECTED);
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiInitiatePiisConsentResponseSpiResponse, ServiceType.PIIS);
            log.info("Consent-ID: [{}]. Create piis consent  with response failed. Consent rejected. Couldn't initiate PIIS consent at SPI level: {}", (Object)encryptedConsentId, (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        SpiInitiatePiisConsentResponse spiInitiatePiisConsentResponse = (SpiInitiatePiisConsentResponse)spiInitiatePiisConsentResponseSpiResponse.getPayload();
        SpiAccountReference spiAccountReference = spiInitiatePiisConsentResponse.getSpiAccountReference();
        AccountAccess accountAccess = new AccountAccess(Collections.singletonList(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiAccountReference)), Collections.emptyList(), Collections.emptyList(), null);
        this.accountReferenceUpdater.rewriteAccountAccess(encryptedConsentId, accountAccess, ConsentType.PIIS_TPP);
        ConsentStatus consentStatus = piisConsent.getConsentStatus();
        boolean multilevelScaRequired = spiInitiatePiisConsentResponse.isMultilevelScaRequired();
        this.updateMultilevelSca(encryptedConsentId, multilevelScaRequired);
        Xs2aConfirmationOfFundsResponse xs2aConfirmationOfFundsResponse = new Xs2aConfirmationOfFundsResponse(consentStatus.getValue(), encryptedConsentId, multilevelScaRequired, this.requestProviderService.getInternalRequestIdString(), spiInitiatePiisConsentResponse.getPsuMessage());
        if (this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(xs2aConfirmationOfFundsResponse, psuData, encryptedConsentId);
        }
        return ResponseObject.builder().body(xs2aConfirmationOfFundsResponse).build();
    }

    public ResponseObject<PiisConsent> getPiisConsentById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_REQUEST_RECEIVED);
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Get PIIS consent failed: initial consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        SpiResponse<SpiConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(piisConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIIS);
            log.info("Get PIIS consent status failed: Couldn't get PIIS consent status at SPI level: {}", (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus consentStatus = ((SpiConsentStatusResponse)spiResponse.getPayload()).getConsentStatus();
        piisConsent.setConsentStatus(consentStatus);
        this.xs2aPiisConsentService.updateConsentStatus(consentId, consentStatus);
        return ResponseObject.builder().body(piisConsent).build();
    }

    public ResponseObject<ConsentStatusResponse> getPiisConsentStatusById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.GET_PIIS_CONSENT_STATUS_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder<ConsentStatusResponse> responseBuilder = ResponseObject.builder();
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Get PIIS consent failed: initial consent not found by id", (Object)consentId);
            return responseBuilder.fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        SpiResponse<SpiConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(piisConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIIS);
            log.info("Get PIIS consent status failed: Couldn't get PIIS consent status at SPI level: {}", (Object)errorHolder);
            return responseBuilder.fail(new MessageError(errorHolder)).build();
        }
        SpiConsentStatusResponse spiPayload = (SpiConsentStatusResponse)spiResponse.getPayload();
        ConsentStatus consentStatus = spiPayload.getConsentStatus();
        this.xs2aPiisConsentService.updateConsentStatus(consentId, consentStatus);
        return responseBuilder.body(new ConsentStatusResponse(consentStatus, spiPayload.getPsuMessage())).build();
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        return this.piisConsentAuthorisationService.getConsentInitiationAuthorisations(consentId);
    }

    public ResponseObject<Xs2aScaStatusResponse> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        ResponseObject<ConfirmationOfFundsConsentScaStatus> consentScaStatusResponse = this.piisConsentAuthorisationService.getConsentAuthorisationScaStatus(consentId, authorisationId);
        if (consentScaStatusResponse.hasError()) {
            return ResponseObject.builder().fail(consentScaStatusResponse.getError()).build();
        }
        ConfirmationOfFundsConsentScaStatus consentScaStatus = consentScaStatusResponse.getBody();
        Xs2aScaStatusResponse response = new Xs2aScaStatusResponse(consentScaStatus.getScaStatus(), null);
        return ResponseObject.builder().body(response).build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordConsentTppRequest(consentId, EventType.DELETE_PIIS_CONSENT_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder responseBuilder = ResponseObject.builder();
        Optional<PiisConsent> piisConsentById = this.xs2aPiisConsentService.getPiisConsentById(consentId);
        if (piisConsentById.isEmpty()) {
            log.info("Consent-ID: [{}]. Delete PIIS consent failed: initial consent not found by id", (Object)consentId);
            return responseBuilder.fail(ErrorType.PIIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        PiisConsent piisConsent = piisConsentById.get();
        ValidationResult validationResult = this.confirmationOfFundsConsentValidationService.validateConsentOnDelete(piisConsent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID: [{}]. Delete Confirmation of Funds Consent - validation failed: {}", (Object)piisConsent.getId(), (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiContextData contextData = this.getSpiContextData();
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        SpiResponse revokePiisConsentResponse = this.piisConsentSpi.revokePiisConsent(contextData, spiPiisConsent, aspspDataProvider);
        if (revokePiisConsentResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(revokePiisConsentResponse, ServiceType.PIIS);
            log.info("Consent-ID: [{}]. Delete Confirmation of Funds Consent failed: Couldn't revoke PIIS consent at SPI level: {}", (Object)piisConsent.getId(), (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        ConsentStatus newConsentStatus = piisConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
        this.xs2aPiisConsentService.updateConsentStatus(consentId, newConsentStatus);
        return ResponseObject.builder().build();
    }

    public ResponseObject<AuthorisationResponse> createPiisAuthorisation(PsuIdData psuData, String consentId, String password) {
        return this.piisConsentAuthorisationService.createPiisAuthorisation(psuData, consentId, password);
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.xs2aPiisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        return this.piisConsentAuthorisationService.updateConsentPsuData(updatePsuData);
    }

    private SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("Corresponding PSU-ID {} was provided from request.", (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    private SpiResponse<SpiConsentStatusResponse> getConsentStatusFromSpi(PiisConsent piisConsent, String consentId) {
        SpiPiisConsent spiPiisConsent = this.xs2aToSpiPiisConsentMapper.mapToSpiPiisConsent(piisConsent);
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        return this.piisConsentSpi.getConsentStatus(this.spiContextDataProvider.provide(), spiPiisConsent, aspspDataProvider);
    }

    private void proceedImplicitCaseForCreateConsent(Xs2aConfirmationOfFundsResponse response, PsuIdData psuData, String consentId) {
        ((PiisAuthorizationService)this.piisScaAuthorisationServiceResolver.getService()).createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorisationId()));
    }

    @ConstructorProperties(value={"xs2aPiisConsentService", "tppService", "xs2aEventService", "requestProviderService", "piisConsentSpi", "spiContextDataProvider", "xs2aToSpiPiisConsentMapper", "aspspConsentDataProviderFactory", "spiErrorMapper", "accountReferenceUpdater", "spiToXs2aAccountReferenceMapper", "createPiisConsentValidator", "authorisationMethodDecider", "piisScaAuthorisationServiceResolver", "consentAuthorisationService", "confirmationOfFundsConsentValidationService", "piisConsentAuthorisationService"})
    public PiisConsentService(Xs2aPiisConsentService xs2aPiisConsentService, TppService tppService, Xs2aEventService xs2aEventService, RequestProviderService requestProviderService, PiisConsentSpi piisConsentSpi, SpiContextDataProvider spiContextDataProvider, Xs2aToSpiPiisConsentMapper xs2aToSpiPiisConsentMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper, CreatePiisConsentValidator createPiisConsentValidator, AuthorisationMethodDecider authorisationMethodDecider, PiisScaAuthorisationServiceResolver piisScaAuthorisationServiceResolver, ConsentAuthorisationService consentAuthorisationService, ConfirmationOfFundsConsentValidationService confirmationOfFundsConsentValidationService, PiisConsentAuthorisationService piisConsentAuthorisationService) {
        this.xs2aPiisConsentService = xs2aPiisConsentService;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.requestProviderService = requestProviderService;
        this.piisConsentSpi = piisConsentSpi;
        this.spiContextDataProvider = spiContextDataProvider;
        this.xs2aToSpiPiisConsentMapper = xs2aToSpiPiisConsentMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
        this.createPiisConsentValidator = createPiisConsentValidator;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.piisScaAuthorisationServiceResolver = piisScaAuthorisationServiceResolver;
        this.consentAuthorisationService = consentAuthorisationService;
        this.confirmationOfFundsConsentValidationService = confirmationOfFundsConsentValidationService;
        this.piisConsentAuthorisationService = piisConsentAuthorisationService;
    }
}

