/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.MessageCode2XX;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.psd2.model.TppMessage2XX;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aChosenScaMethod;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.GetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperPsd2 {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperPsd2.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final AmountModelMapper amountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public Object mapToGetPaymentResponse(CommonPayment commonPayment) {
        String rawData = this.convertResponseToRawData(commonPayment.getPaymentData());
        return this.standardPaymentProductsResolver.isRawPaymentProduct(commonPayment.getPaymentProduct()) ? rawData : this.enrichPaymentWithAdditionalData(rawData, commonPayment);
    }

    private Object enrichPaymentWithAdditionalData(String rawData, CommonPayment commonPayment) {
        try {
            Map map = (Map)this.xs2aObjectMapper.readValue(rawData, Map.class);
            map.put("transactionStatus", commonPayment.getTransactionStatus().toString());
            return map;
        }
        catch (JsonProcessingException e) {
            log.warn("Can't convert payment to map {}", (Object)e.getMessage());
            return rawData;
        }
    }

    public PaymentInitiationStatusResponse200Json mapToStatusResponseJson(GetPaymentStatusResponse response) {
        return new PaymentInitiationStatusResponse200Json().transactionStatus(this.mapToTransactionStatus(response.getTransactionStatus())).fundsAvailable(response.getFundsAvailable()).psuMessage(response.getPsuMessage());
    }

    public byte[] mapToStatusResponseRaw(GetPaymentStatusResponse response) {
        return response.getPaymentStatusRaw();
    }

    public PaymentInitationRequestResponse201 mapToPaymentInitiationResponse(PaymentInitiationResponse response) {
        PaymentInitationRequestResponse201 response201 = new PaymentInitationRequestResponse201();
        response201.setTransactionStatus(this.mapToTransactionStatus(response.getTransactionStatus()));
        response201.setPaymentId(response.getPaymentId());
        response201.setTransactionFees(this.amountModelMapper.mapToAmount(response.getTransactionFees()));
        response201.setTransactionFeeIndicator(response.getTransactionFeeIndicator());
        response201.setScaMethods(this.scaMethodsMapper.mapToScaMethods(response.getScaMethods()));
        response201.setChallengeData(this.coreObjectsMapper.mapToChallengeData(response.getChallengeData()));
        response201.setLinks(this.hrefLinkMapper.mapToLinksMap(response.getLinks()));
        response201.setPsuMessage(response.getPsuMessage());
        response201.setTppMessages(this.mapToTppMessage2XXList(response.getTppMessageInformation()));
        response201.setCurrencyConversionFee(this.amountModelMapper.mapToAmount(response.getCurrencyConversionFee()));
        response201.setEstimatedTotalAmount(this.amountModelMapper.mapToAmount(response.getEstimatedTotalAmount()));
        response201.setEstimatedInterbankSettlementAmount(this.amountModelMapper.mapToAmount(response.getEstimatedInterbankSettlementAmount()));
        return response201;
    }

    public PaymentInitiationParameters mapToPaymentRequestParameters(String paymentProduct, String paymentService, byte[] tpPSignatureCertificate, String tpPRedirectURI, String tpPNokRedirectURI, boolean tppExplicitAuthorisationPreferred, PsuIdData psuData, TppNotificationData tppNotificationData, String tppBrandLoggingInformation, String instanceId) {
        PaymentInitiationParameters parameters = new PaymentInitiationParameters();
        parameters.setPaymentType((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new IllegalArgumentException("Unsupported payment service")));
        parameters.setPaymentProduct(Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")));
        parameters.setQwacCertificate(new String(Optional.ofNullable(tpPSignatureCertificate).orElse(new byte[0]), StandardCharsets.UTF_8));
        parameters.setTppRedirectUri(this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI));
        parameters.setTppExplicitAuthorisationPreferred(tppExplicitAuthorisationPreferred);
        parameters.setPsuData(psuData);
        parameters.setTppNotificationData(tppNotificationData);
        parameters.setTppBrandLoggingInformation(tppBrandLoggingInformation);
        parameters.setInstanceId(instanceId);
        return parameters;
    }

    public PisPaymentCancellationRequest mapToPaymentCancellationRequest(String paymentProduct, String paymentService, String paymentId, Boolean tppExplicitAuthorisationPreferred, String tpPRedirectURI, String tpPNokRedirectURI) {
        return new PisPaymentCancellationRequest((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new IllegalArgumentException("Unsupported payment service")), Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")), paymentId, Boolean.valueOf(BooleanUtils.isTrue((Boolean)tppExplicitAuthorisationPreferred)), this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI));
    }

    public PaymentInitiationCancelResponse202 mapToPaymentInitiationCancelResponse(CancelPaymentResponse cancelPaymentResponse) {
        PaymentInitiationCancelResponse202 response = new PaymentInitiationCancelResponse202();
        response.setTransactionStatus(this.mapToTransactionStatus(cancelPaymentResponse.getTransactionStatus()));
        response.setScaMethods(this.scaMethodsMapper.mapToScaMethods(cancelPaymentResponse.getScaMethods()));
        response.setChosenScaMethod(this.mapToChosenScaMethod(cancelPaymentResponse.getChosenScaMethod()));
        response.setChallengeData(this.coreObjectsMapper.mapToChallengeData(cancelPaymentResponse.getChallengeData()));
        response._links(this.hrefLinkMapper.mapToLinksMap(cancelPaymentResponse.getLinks()));
        response.setTppMessages(this.mapToTppMessage2XXList(cancelPaymentResponse.getTppMessageInformation()));
        return response;
    }

    private de.adorsys.psd2.model.TransactionStatus mapToTransactionStatus(TransactionStatus responseObject) {
        return Optional.ofNullable(responseObject).map(r -> de.adorsys.psd2.model.TransactionStatus.valueOf((String)r.name())).orElse(null);
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aChosenScaMethod xs2aChosenScaMethod) {
        return Optional.ofNullable(xs2aChosenScaMethod).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(ch.getAuthenticationType());
            return method;
        }).orElse(null);
    }

    private String convertResponseToRawData(byte[] paymentData) {
        try {
            return IOUtils.toString((byte[])paymentData, (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            log.warn("Can not convert payment from byte[] ", (Throwable)e);
            return null;
        }
    }

    private List<TppMessage2XX> mapToTppMessage2XXList(Set<TppMessageInformation> tppMessages) {
        if (CollectionUtils.isEmpty(tppMessages)) {
            return null;
        }
        return tppMessages.stream().map(this::mapToTppMessage2XX).collect(Collectors.toList());
    }

    private TppMessage2XX mapToTppMessage2XX(TppMessageInformation tppMessage) {
        TppMessage2XX tppMessage2XX = new TppMessage2XX();
        tppMessage2XX.setCategory(TppMessageCategory.fromValue((String)tppMessage.getCategory().name()));
        tppMessage2XX.setCode(MessageCode2XX.WARNING);
        tppMessage2XX.setPath(tppMessage.getPath());
        tppMessage2XX.setText(tppMessage.getText());
        return tppMessage2XX;
    }

    @ConstructorProperties(value={"coreObjectsMapper", "tppRedirectUriMapper", "amountModelMapper", "hrefLinkMapper", "scaMethodsMapper", "standardPaymentProductsResolver", "xs2aObjectMapper"})
    public PaymentModelMapperPsd2(CoreObjectsMapper coreObjectsMapper, TppRedirectUriMapper tppRedirectUriMapper, AmountModelMapper amountModelMapper, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper, StandardPaymentProductsResolver standardPaymentProductsResolver, Xs2aObjectMapper xs2aObjectMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.amountModelMapper = amountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

