/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AccountLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;
    private final LoggingContextService loggingContextService;
    private final PathParameterExtractor pathParameterExtractor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map<String, String> pathVariables = this.pathParameterExtractor.extractParameters(request);
        String accountId = Optional.ofNullable(pathVariables).map(pv -> (String)pv.get("account-id")).orElse(NOT_EXIST_IN_URI);
        ((TppRequestLogBuilder)((TppRequestLogBuilder)TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withRequestUri().withParam("Account ID", accountId)).withParam("Consent ID", request.getHeader("Consent-ID"))).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ((TppResponseLogBuilder)TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withResponseStatus().withParam("consentStatus", this.loggingContextService.getConsentStatus())).perform();
    }

    @ConstructorProperties(value={"tppService", "loggingContextService", "pathParameterExtractor"})
    public AccountLoggingInterceptor(TppService tppService, LoggingContextService loggingContextService, PathParameterExtractor pathParameterExtractor) {
        this.tppService = tppService;
        this.loggingContextService = loggingContextService;
        this.pathParameterExtractor = pathParameterExtractor;
    }
}

