/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationResult {
    private final boolean valid;
    @Nullable
    private final MessageError messageError;

    public static ValidationResult valid() {
        return new ValidationResult(true, null);
    }

    public static ValidationResult invalid(@NotNull MessageError messageError) {
        return new ValidationResult(false, messageError);
    }

    public static ValidationResult invalid(@NotNull ErrorType errorType, MessageErrorCode messageErrorCode) {
        return new ValidationResult(false, new MessageError(errorType, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)messageErrorCode)}));
    }

    public static ValidationResult invalid(@NotNull ErrorType errorType, TppMessageInformation tppMessageInformation) {
        return new ValidationResult(false, new MessageError(errorType, new TppMessageInformation[]{tppMessageInformation}));
    }

    public static ValidationResult invalid(@NotNull ErrorType errorType, TppMessageInformation ... tppMessageInformations) {
        return new ValidationResult(false, new MessageError(errorType, tppMessageInformations));
    }

    private ValidationResult(boolean valid, @Nullable MessageError messageError) {
        this.valid = valid;
        this.messageError = messageError;
    }

    public boolean isNotValid() {
        return !this.valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Nullable
    public MessageError getMessageError() {
        return this.messageError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (this.isValid() != other.isValid()) {
            return false;
        }
        MessageError this$messageError = this.getMessageError();
        MessageError other$messageError = other.getMessageError();
        return !(this$messageError == null ? other$messageError != null : !this$messageError.equals(other$messageError));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        MessageError $messageError = this.getMessageError();
        result = result * 59 + ($messageError == null ? 43 : $messageError.hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(valid=" + this.isValid() + ", messageError=" + this.getMessageError() + ")";
    }
}

