/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.CardTransaction;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountReport;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCardTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiCardTransactionListToXs2aAccountReportMapper {
    private static final Predicate<SpiCardTransaction> BOOKED_PREDICATE = SpiCardTransaction::isBookedTransaction;
    private static final Predicate<SpiCardTransaction> PENDING_PREDICATE = SpiCardTransaction::isPendingTransaction;
    private final SpiToXs2aCardTransactionMapper toXs2aCardTransactionMapper;

    public Optional<Xs2aCardAccountReport> mapToXs2aCardAccountReport(BookingStatus bookingStatus, List<SpiCardTransaction> spiCardTransactions, byte[] rawTransactionsResponse) {
        if (ArrayUtils.isNotEmpty((byte[])rawTransactionsResponse)) {
            return Optional.of(new Xs2aCardAccountReport(null, null, null, rawTransactionsResponse));
        }
        if (CollectionUtils.isEmpty(spiCardTransactions)) {
            return Optional.empty();
        }
        if (bookingStatus == BookingStatus.INFORMATION) {
            return Optional.of(new Xs2aCardAccountReport(null, null, this.toXs2aCardTransactionMapper.mapToXs2aCardTransactionList(spiCardTransactions), null));
        }
        List<CardTransaction> booked = Collections.emptyList();
        List<CardTransaction> pending = Collections.emptyList();
        if (bookingStatus != BookingStatus.PENDING) {
            booked = this.filterTransaction(spiCardTransactions, BOOKED_PREDICATE);
        }
        if (bookingStatus != BookingStatus.BOOKED) {
            pending = this.filterTransaction(spiCardTransactions, PENDING_PREDICATE);
        }
        return Optional.of(new Xs2aCardAccountReport(booked, pending, null, null));
    }

    @NotNull
    private List<CardTransaction> filterTransaction(List<SpiCardTransaction> spiTransactions, Predicate<SpiCardTransaction> predicate) {
        return spiTransactions.stream().filter(predicate).map(this.toXs2aCardTransactionMapper::mapToXs2aCardTransaction).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"toXs2aCardTransactionMapper"})
    public SpiCardTransactionListToXs2aAccountReportMapper(SpiToXs2aCardTransactionMapper toXs2aCardTransactionMapper) {
        this.toXs2aCardTransactionMapper = toXs2aCardTransactionMapper;
    }
}

